#ifndef MBED_BAR_CHART_H
#define MBED_BAR_CHART_H

#include "mbed.h"
/** Bar chart output class, based on an array of PwmOuts
*
* Example:
 * @code
 * // Display the voltage at pin 20 as a bar chart on the on-board LEDs
 * #include "mbed.h"
 * #include "BarChart.h"
 *
 * BarChart b;
 * AnalogIn input(p20);

 * int main() {
 *    //Set the maximum and minimum LED brightness
 *    b.setOutputLimits(0.1,0.9);
 *
 *    while(1) {
 *        b = input;
 *        //equivalent to b.show(in);
 *
 *        wait(0.01);
 *    }
 * }
 * @endcode
 */
class BarChart {
public:
    /** Create a Bar chart from the 4 LEDs mounted on the board */
    BarChart();
    /** Create a Bar chart from the (PWM) pins specified
     *
     * @param pxx the pins to use, lowest bar first
     */
    BarChart(PinName p1,  PinName p2,  PinName p3 = NC,  PinName p4 = NC,
                   PinName p5 = NC,  PinName p6 = NC,  PinName p7 = NC,  PinName p8 = NC,
                   PinName p9 = NC,  PinName p10 = NC, PinName p11 = NC, PinName p12 = NC,
                   PinName p13 = NC, PinName p14 = NC, PinName p15 = NC, PinName p16 = NC);
    /** Set the range of input that will be provided to the BarChart
     *
     * @param min The lowest value that the barchart will display
     * @param max The highest value that the barchart will display
     */
    void setInputLimits(float min, float max);
    /** Set the range of output that will be provided to the PWM pins
     *
     * @param min The lowest duty cycle of the PwmOuts
     * @param max The highest duty cycle of the PwmOuts
     */
    void setOutputLimits(float min, float max);
    /** Output the value to the PwmOuts
     *
     * @param value The value to display
     */
    void show(float value);
    /** Shorthand for the show function */
    BarChart& operator = (float value) {
        show(value);
        return *this;
    };
    ~BarChart();
private:
    PwmOut **_outputs;
    int _numPins;
    float _maxInput;
    float _minInput;
    float _maxOutput;
    float _minOutput;
    float _linearScale(float value);
    void _init();
};

#endif