#include "BarChart.h"
#include "mbed.h"


BarChart::~BarChart() {
    for(int i = 0; i < _numPins; i++)
    {
        delete _outputs[i];
    }
    delete [] _outputs;
}

BarChart::BarChart() {
    PwmOut ** tmp = _outputs = new PwmOut*[4];
    *tmp++ = new PwmOut(LED1);
    *tmp++ = new PwmOut(LED2);
    *tmp++ = new PwmOut(LED3);
    *tmp++ = new PwmOut(LED4);
    _numPins = 4;
    _init();
}

BarChart::BarChart (PinName p1,  PinName p2,  PinName p3,  PinName p4,
             PinName p5,  PinName p6,  PinName p7,  PinName p8,
             PinName p9,  PinName p10, PinName p11, PinName p12,
             PinName p13, PinName p14, PinName p15, PinName p16){
    PinName all[16] = {p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16};

    _numPins = 0;
    for (int i = 0; i < 16; i++)
        if (all[i] != NC)
            _numPins++;

    _outputs = new PwmOut*[_numPins];

    _numPins = 0;
    for (int i = 0; i < 16; i++)
        if (all[i] != NC)
            _outputs[_numPins++] = new PwmOut(all[i]);

    _init();
}

void BarChart::_init() {
    setInputLimits(0, 1);
    setOutputLimits(0, 1);
}

void BarChart::setInputLimits(float min, float max) {
    _minInput = min;
    _maxInput = max;
}

void BarChart::setOutputLimits(float min, float max) {
    _minOutput = min;
    _maxOutput = max;
}

float BarChart::_linearScale(float value) {
    return (value - _minInput)/(_maxInput - _minInput);
}

void BarChart::show(float value) {
    value = _linearScale(value) * _numPins;

    for (int i = 0; i < _numPins; i++) {
       if (i < value - 1)
            *_outputs[i] = _maxOutput;
        else if (i > value)
            *_outputs[i] = _minOutput;
        else
            *_outputs[i] = _minOutput + (value - i)*(_maxOutput - _minOutput);
    }
}
