#include "mbed.h"
#define reset       0b00000000          //Define masks 
#define digital     0b00100000
#define analog      0b01000000
#define I2C         0b01100000
#define stateMask   0b11100000
#define pinMask     0b00011111
#define pin1        0b00010000
#define pin2        0b00001000
#define pin3        0b00000100
#define pin4        0b00000010
#define pin5        0b00000001


DigitalOut myled(LED1);
DigitalOut DigitalStatus(LED2);

DigitalIn  d1(p21);                     //Always set these pins for digital in
DigitalIn  d2(p22);
DigitalIn  d3(p23);
DigitalIn  d4(p24);
DigitalIn  d5(p25);

AnalogIn   a1(p16);                     //Always set these pins for analog in 
AnalogIn   a2(p17);
AnalogIn   a3(p18);
AnalogIn   a4(p19);
AnalogIn   a5(p20);



Serial PC(USBTX,USBRX);                                      
Ticker tickerboi;                                               //Initialize the ticker for Sampling

volatile uint8_t DigitalSample;
volatile unsigned char command;
volatile unsigned char pins;
volatile bool DigitalRunning;
volatile unsigned char state;
volatile bool newdigital=false;


 
 
void sample_func(void){                         //sampling function, samples each pin specified and Ors it 
    DigitalSample = digital;
    
    if( (command & pin1) == pin1){
        DigitalSample=DigitalSample +  d1*pin1;
    }
    if( (command & pin2) == pin2){
        DigitalSample=DigitalSample + d2*pin2;
    }
    if( (command & pin3) == pin3){
        DigitalSample=DigitalSample + d3*pin3;
    }
    if( (command & pin4) == pin4){
        DigitalSample=DigitalSample + d4*pin4;
    }
    if( (command & pin5) == pin5){
        DigitalSample=DigitalSample + d5*pin5;
    }
    newdigital=true;                                //tell main loop new data available to send
}

void SerialInterrupt(void){
       command=PC.getc();
       state= command & stateMask;
       switch(state){
           case reset:
            tickerboi.detach();                          //detach Ticker
            DigitalRunning=false;                        //turn off status LED
            break;
                
           case digital:
            tickerboi.attach(&sample_func, .1);          //Ticker will call sample func every 100 ms  
            DigitalRunning=true;                        // Bool to control status LED
            break;           
        }  
}

int main() {
     PC.attach(&SerialInterrupt, Serial::RxIrq);
    
    
    while(1) {
        
        DigitalStatus=DigitalRunning;                  //Status LED = Digital Running bool
        if(newdigital){                      //if the sample_func was run, this will send the new data
            PC.putc(DigitalSample);
            newdigital=false;               //new data sent, no need to send anything else
        }
        
        myled = 1;                                //indicate the Main loop is running
        wait(0.2);
        myled = 0;
        wait(0.2);  
    }
}