#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"


//Este código lo hicimos basado en el programa pid_teclas de TONY63

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7 son los puertos del módulo LCD 2x16
AnalogIn y(PTB1);     //puerto de entrada analógica
AnalogOut u(PTE30);    //puerto de salida analógica
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DebouncedIn button1(PTC12);   //botón aumentar
DebouncedIn button2(PTC13);   //botón disminuir
DebouncedIn button3(PTC16);   //botón cambiar menú
DebouncedIn button4(PTC17);   //botón enter

int C1=0x0F;  //muestra el cursor
int C4=0x0C; // quito cursor bajo
int sp=0,kp=0,kd=0,ki=0,p=1;
int yr, ap, ai, ad, err, med, err_v, cycle, pid; 
int b; 
int pidn;
Timer t;

int incremento(int c,int f,int aux)    //función auxiliar para el botón de aumentar
{
int bandera=0,i=0;
        
 while(button1==0)   
 {
i=1;
 wait (0.5);  
             
                        
  if ((bandera==2)&(i==1)) // si el módulo de la constante dividido 100 es cero
  {
 aux = aux+100; 
 if (aux>=999)
{
aux = 999;
}
                                          
lcd.locate(c,f);
lcd.printf("   ");
lcd.locate(c,f);
lcd.printf("%d", aux);
i=0;
                               
 }
if ((bandera==1)&(i==1))
{
aux=aux+10;
if(aux%100==0){bandera=2;} // si el módulo de la constante dividido 100 es cero, la bandera es igual a 2
if (aux>= 999)
{
aux = 999;
}
                          
                                           
lcd.locate(c,f);
lcd.printf("   ");
lcd.locate(c,f);
lcd.printf("%d", aux);
i=0;            }
                
if ((bandera==0)&(i==1))
 {
++aux;  
if(aux%10==0){bandera=1;}
if (aux>= 999)
{
aux = 999;
}
                          
                                             
lcd.locate(c,f);
lcd.printf("   ");
lcd.locate(c,f);
lcd.printf("%d", aux);
i=0; }
                               
                               
                                
}
bandera=0;
return aux;
}
    
int decremento(int c,int f,int aux)     //función auxiliar para el botón disminuir
{
int bandera=0,i=0;
        
while(button2==0)   
{
                    
i=1;
wait (0.5);
                        
if ((bandera==2)&(i==1))
{
aux = aux-100; 
if (aux<=0)
{
aux = 0;
}
                                          
lcd.locate(c,f);
lcd.printf("   ");
lcd.locate(c,f);
lcd.printf("%d", aux);
i=0;
                               
 }
if ((bandera==1)&(i==1))
{
aux=aux-10;
if(aux%100==0){bandera=2;}
if (aux<=0)
{
aux = 0;
}
                                           
lcd.locate(c,f);
lcd.printf("   ");
lcd.locate(c,f);
lcd.printf("%d", aux);
i=0;            }
                
 if ((bandera==0)&(i==1))
 {
--aux;  
if(aux%10==0){bandera=1;}
if (aux<=0)
{
aux = 0;
}
                                             
lcd.locate(c,f);
lcd.printf("   ");
lcd.locate(c,f);
lcd.printf("%d", aux);
i=0; }
                               
                               
                                
}
            
bandera=0;
return aux;
};


int main()
{
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(8,0);
    lcd.printf("kp=%d", kp);
    lcd.locate(0,1);
    lcd.printf("Ki=%d", ki);
    lcd.locate(8,1);
    lcd.printf("Kd=%d", kd);
    lcd.locate(0,0);
    lcd.printf("Sp=%d", sp);

    while(1)
    {
        if (button1.falling())
        {
            led1 =!led1;
            if (p==1)
            {
                ++sp;
                  if (sp>=999)//se limita hasta 999
                    {
                       sp= 999;
                    }
                lcd.locate(3,0);
                lcd.printf("   ");
                lcd.locate(3,0);
                lcd.printf("%d", sp);
                wait (0.5);
                sp=incremento(3,0,sp);    //se llama la función auxiliar
            }
            else if (p==2)
            {
                ++kp;
                  if (kp>=999)//se limita hasta 999
                    {
                       kp= 999;
                    }
                lcd.locate(11,0);
                lcd.printf("   ");
                lcd.locate(11,0);
                lcd.printf("%d", kp);
                wait (0.5);
                kp=incremento(11,0,kp);    //se llama la función auxiliar
            }
            else if (p==3)
            {
                ++ki;
                    if (ki>=999)
                    {
                       ki= 999;
                    }
                lcd.locate(3,1);
                lcd.printf("   ");
                lcd.locate(3,1);
                lcd.printf("%d", ki);
                wait (0.5);
                ki =incremento(3,1,ki);    //se llama la función auxiliar
            }
            else if (p==4)
            {
                ++kd;
                if (kd>=999)
                    {
                       kd = 999;
                    }
                lcd.locate(11,1);
                lcd.printf("   ");
                lcd.locate(11,1);
                lcd.printf("%d", kd);
                wait (0.5);
                kd =incremento(11,1,kd);    //se llama la función auxiliar
            }
        }
        if (button2.falling())
        {
            led2 =!led2;
            if (p==1)
            {
                if (sp==0)  // no mostrar nada
                {
                }
                else
                {
                    --sp;
                    lcd.locate(3,0);
                    lcd.printf("   ");
                    lcd.locate(3,0);
                    lcd.printf("%d", sp);
                    wait(0.5);
                    sp =decremento(3,0,sp);    //se llama la función auxiliar
                }
            }
            if (p==2)
            {
                if (kp==0)  // no mostrar nada
                {
                }
                else
                {
                    --kp;
                    lcd.locate(11,0);
                    lcd.printf("   ");
                    lcd.locate(11,0);
                    lcd.printf("%d", kp);
                    wait(0.5);
                    kp =decremento(11,0,kp);     //se llama la función auxiliar
                }
            }
            if (p==3)
            {
                if (ki==0)  // no mostrar nada
                {
                }
                else
                {
                    --ki;
                    lcd.locate(3,1);
                    lcd.printf("   ");
                    lcd.locate(3,1);
                    lcd.printf("%d", ki);
                    wait(0.5);
                    ki =decremento(3,1,ki);     //se llama la función auxiliar
                }
            }
            if (p==4)
            {
                if (kd==0)  // no mostrar nada
                {
                }
                else
                {
                    --kd;
                    lcd.locate(11,1);
                    lcd.printf("   ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kd);
                    wait(0.5);
                    kd =decremento(11,1,kd);     //se llama la función auxiliar
                }
            }
        }
        if (button3.falling())
        {
            led3 =!led3;
            if (p==1)
            {
                ++p;
                lcd.locate(11,0);
                lcd.printf("%d", kp);
                
                
            }
            else if (p==2)
            {
                ++p;
                lcd.locate(3,1);
                lcd.printf("%d", ki);
                lcd.locate(3,1);
                
            }
            else if (p==3)
            {
                ++p;
                lcd.locate(11,1);
                lcd.printf("%d", kd);
                
                
            }
            else if (p==4)
            {
                p=1;
                lcd.locate(3,0);
                lcd.printf("%d", sp);
                
                
            }
        }
        
        if (button4.falling()){           //Botón Enter
            
         break;        //se sale del ciclo cuando se oprime el botón Enter
        }
        
    }
    
              lcd.writeCommand(C4);//escribimos un comando segun el manual del modulo LCD para quitar cursor bajo
           lcd.cls(); //borra la pantalla
           lcd.printf("VALORES \nGUARDADOS"); 
           wait(2);
           
           // se imprimen los parches del control  *****************************************
           lcd.cls();
           lcd.printf("Er=%d",err);
           lcd.locate(8,0);
           lcd.printf("Me=%d",med);
           lcd.locate(0,1);
           lcd.printf("Sp=%d",sp);
           lcd.locate(8,1);
           lcd.printf("Co=%d",pid);
           wait(2); 
           
           
                      // CICLO PRINCIPAL CONTROLADOR PID
           while(1) {
           med=1000*y.read();                   //leer puerto analogo y asignar a med
           err = (sp-med);
           ap = kp*err;
            ai =(ki*err)+ai;    //calculo de la integral del error     
           ad = kd*(err-err_v); //calculo de la accion derivativa
           pid = (ap+ai+ad);
           
              
            if (pid > 999){
            pid=1000;
            } 
            else if (pid<0){
            pid=0;
            }     
           // se actualizan las variables *******************************************
           err_v = err;         
           
           //se muestran las variables******************************************
           
           if (b==0)
           {
            t.start();
            b=1;
           }
if (t>=0.4){
wait(0.05);
lcd.locate(3,0);
lcd.printf("     ");
lcd.locate(3,0);
lcd.printf("%d",err);
lcd.locate(11,0);
lcd.printf("     ");
lcd.locate(11,0);
lcd.printf("%d",med);
lcd.locate(3,1);
lcd.printf("     ");
lcd.locate(3,1);
lcd.printf("%d",sp);
lcd.locate(11,1);
lcd.printf("     ");
lcd.locate(11,1);
lcd.printf("%d ",pid);
t.reset();
b=0;
}
           
           //Normalizacion de la salida
           pidn=pid/1000;
           //  se envia el valor pid a puerto analogico de salida (D/A) **************
           u.write(pidn);
          
           //  se repite el ciclo
           wait(0.1);
           }
           
                      
        }
    
