//
// Created by yanick on 15.03.2019.
//

#ifndef PA_LED_RING_H
#define PA_LED_RING_H

#include "mbed.h"
#include "rtos.h"

class LED_Ring{
private:
    PwmOut redLED;//(PC_9);
    PwmOut greenLED;//(PB_8);

    Thread thread;
    Ticker ticker;

    enum ledStates {off, shine_red, shine_green, shine_orange, blink_red, blink_green, blink_orange, blink_red_green};
    ledStates ledState;

    /**
     *
     */
    void run();

public:
    /**
     * Initialisert den LED-Ring
     */
    LED_Ring();

    /**
     * Lässt den LED-Ring rot leuchten.
     */
    void shineRed();

    /**
     * Lässt den LED-Ring grün leuchten.
     */
    void shineGreen();

    /**
     * Lässt den LED-Ring Orange leuchten.
     */
    void shineOrange();

    /**
     * Lässt den LED-Ring rot blinken.
     */
    void blinkRed();

    /**
     * Lässt den LED-Ring grün blinken.
     */
    void blinkGreen();

    /**
     * Lässt den LED-Ring orange blinken.
     */
    void blinkOrange();

    /**
     * Lässt den LED-Ring rot-grün blinken.
     */
    void blinkRedGreen();

    /**
     * Schaltet die LED aus.
     */
    void turnOfLED();

    /**
     * Einfacherer Weg, um die Led zu steuern
     * @param cmd Befehl für den Zustand der LED: "off", "blink red", "shine green" etc.
     */
    //void operator=(string cmd);

};


#endif //PA_LED_RING_H
