// B16_TEST V0.9 Alles  
// SHOW SOFTWARE für B16  
// BULME Graz,     by Enenkel   26.5.2016
/* 
 */
 
#include "mbed.h"
// ********   Definitionen  **********
DigitalOut Von(P2_13);       // 12V on
// Definition der 12 LED's 
DigitalOut WSLI(P1_10);     //wsS links  D1
DigitalOut WSRE(P1_12);     //wsS rechts D4
DigitalOut GELIVO (P1_11);  //ge links vorn D2
DigitalOut GEREVO (P1_13);  //ge rechts vorn D5
DigitalOut GELIHI(P1_14);   //ge links hinten D6
DigitalOut RTLIHI(P1_15);   // rt links hinbten D7        
DigitalOut GEREHI(P1_16);   //ge rechts hinten D8
DigitalOut RTREHI(P1_17);   //rt  rechts hinten D9

DigitalOut ledD10(P1_18);
DigitalOut ledD11(P2_16);
DigitalOut ledD12(P1_20);
DigitalOut ledD13(P1_21);
// LDR 
AnalogIn LDR(P0_14);
// RGB LED
DigitalOut RGB(P1_22);
// Motor Steuerung                    Schaltung Pg 2
DigitalOut MG1_EN(P2_16);// NUR DIGITAL ohne PWM ! ! !
DigitalOut MG1_F(P2_15);
DigitalOut MG1_R(P2_14);
DigitalOut MG2_EN(P2_19);
DigitalOut MG2_F(P2_20);
DigitalOut MG2_R(P2_21);
//ULTRASCHALL ABSTANDSMESSER
DigitalOut TRIG(P2_22);
DigitalIn ECHO(P2_23);
// Definition der Taster **************** Schaltplan Pg5
DigitalIn  TA1(P1_23); //TA1
DigitalIn  TA2(P1_24); //
DigitalIn  TA3(P1_25); //
DigitalIn  TA4(P1_26); // 
DigitalIn  TA5(P1_27); //
DigitalIn  TA6(P1_28); //
DigitalIn  TA7(P1_30); //
DigitalIn  TA8(P1_31); // 
// INCREMENTGEBER  *********************** Schaltplan Pg 6
DigitalOut EN_INCR (P2_2);  //Incrementgeber Enable
DigitalIn INCR_L1 (P2_6);
DigitalIn INCR_L2 (P2_7); 
DigitalIn INCR_R1 (P2_8);  
DigitalIn INCR_R2 (P2_9); 
// LINE SENSOR *************************** Schaltplan Pg 7
DigitalOut EN_Line (P2_5); //Enable LINE Sensor
DigitalIn ISO1 (P1_9);  // Statt ANALOG hier DIGITAL
DigitalIn ISO2 (P0_23); // nur für einfachen TEST!
DigitalIn ISO3 (P0_16);
DigitalIn ISO4 (P0_15);
DigitalIn ISO5 (P1_3);
// Blue LED ****************************** Schaltplan Pg 8
DigitalOut LedBl (P1_5);

// WLAN fehlt
// RS232 via FT232Modul fehlt

//********************************************************
// Konstante 
int t;    //time const
int t2;
int b;    //LedTest                  
int a;    //LedTest    
int j;   

void LedTest();                  // Testet alle LED des B16 **********
void vor();
void ret();   // Rechts Turn 90^
void retu();
void litu();
void lituf();
void retuf();
void TasterTest();
void LDRTest();                  // Test für den LDR

void RGBTest();                  // RGB Test ruft writeled und writebit 
void writeled(uint32_t leddata); // schreibt 3 Byte aufs LED 
void writeledbit(char wert);     // schreibet 1 BIT  aufs LED
//ab hier 12V und 6V Tests
void BlueTest();                 // BLUE LEDS 
void MotorTest();                // Motor Test 
void testOK();                   // alle Led blinken 3 mal
void LineTest();                 // Line Test 
void tu90r();
// Konstante 
int T1,T2,T3,T4,T5,T6,T7,T8;         
// *******************   HAUPTPROGRAMM *******************
int main() {
    t=200;           // 0,2 sec
    t2=500;
    Von=1;
    while(t)
    {
      WSLI=WSRE=GELIVO=GEREVO=GEREHI=GELIHI=RTREHI=RTLIHI=1;
      ledD10=ledD11=ledD12=ledD13=1;
      BlueTest();
      LedTest();
      b=0;
      while (b<2)
      { vor();
        tu90r();
        vor();
        tu90r();
        vor();
        tu90r();
        vor();
        tu90r();
        b++;
     }    
      
    retu();
    lituf();
    retuf();
    vor();
    tu90r();
    vor();
    tu90r();
    vor();
    tu90r();
    vor();
    }
 
    
}    

//********************  Unterprogramme *******************
void tu90r()
{
  Von=1;
  WSLI=WSRE=0;
  MG1_F=1;
  MG1_EN=1;
  GEREVO=GEREHI=0;
  wait (0.3);
  WSLI=WSRE=1;
  MG1_F = MG1_EN = 0;   
  GEREVO=GEREHI=1;  
}    


void vor()
{ a=0;
  while (a<3)
  { Von=1;
    WSLI=WSRE=0;
    MG1_F=MG2_F=1;
    MG1_EN=MG2_EN=1;
    wait_ms(t);
    WSLI=WSRE=1;
    MG1_F=MG2_F=0;
    a++;
  }  
}  
  
void ret()  
 { a=0;
  while (a<3)
  { Von=1;
    WSLI=WSRE=0;
    RTLIHI=RTREHI=0;
    MG1_R=MG2_R=1;
    MG1_EN=MG2_EN=1;
    wait_ms(t);
    WSLI=WSRE=1;
    MG1_R=MG2_R=0;
    RTLIHI=RTREHI=1;
    a++;
  }  
}   

void retu()
{
  a=0;
  while (a<5)
  { Von=1;
    WSLI=WSRE=0;
    GEREVO=GEREHI=0;
    MG1_R=1;
    MG1_EN=1;
    wait (0.3);
    GEREVO=GEREHI=1;
    wait (0.3);
    a++;
  }  
    WSLI=WSRE=1;
    MG1_R=MG2_R=0;
    
}    

void lituf()
{
  a=0;
  while (a<6)
  { Von=1;
    WSLI=WSRE=GELIVO=GEREVO=GEREHI=GELIHI=RTREHI=RTLIHI=0;
    ledD10=ledD11=ledD12=ledD13=0;
    MG1_F=1;
    MG2_R=1;
    MG1_EN=MG2_EN=1;
    wait (0.3);
    WSLI=WSRE=GELIVO=GEREVO=GEREHI=GELIHI=RTREHI=RTLIHI=1;
    ledD10=ledD11=ledD12=ledD13=1;
    wait (0.3);
    a++;
  }  
    WSLI=WSRE=1;
    MG1_F=MG2_R=0;
    MG1_EN=MG2_EN=0;
}    


void retuf()
{
  a=0;
  while (a<6)
  { Von=1;
    WSLI=WSRE=GELIVO=GEREVO=GEREHI=GELIHI=RTREHI=RTLIHI=0;
    ledD10=ledD11=ledD12=ledD13=0;
    
    MG1_R=1;
    MG2_F=1;
    MG1_EN=MG2_EN=1;
    wait (0.3);
    WSLI=WSRE=GELIVO=GEREVO=GEREHI=GELIHI=RTREHI=RTLIHI=1;
    ledD10=ledD11=ledD12=ledD13=1;
    wait (0.3);
    a++;
  }  
    WSLI=WSRE=1;
    MG1_R=MG2_F=0;
    MG1_EN=MG2_EN=0;
}    

void LedTest()  // Testet alle LED des B16 ***************
 {
  a=0;
  while(a<5) 
   {
     GELIVO=0;
      wait_ms(t);
     GELIVO=1;
     GEREVO=0;
      wait_ms (t);
     GEREVO=1;
     GEREHI=0;
      wait_ms (t);
     GEREHI=1;
     GELIHI=0;
      wait_ms (t);
     GELIHI=1;
     a++;
   }     
   a=0;
   while (a<4)
   {
     WSLI=WSRE=RTLIHI=RTREHI=0;
      wait (0.3);
     WSLI=WSRE=RTLIHI=RTREHI=1;
      wait (0.3);
     a++;
    } 
    a=0; 
   
   while (a<4)
   {
     WSLI=0;
     wait (0.25);
     WSLI=1;
     WSRE=0;
     wait (0.25);
     WSRE=1;
     a++;   
   }     
 }    
// ********************* BLAUE LED TESTEN **************
void BlueTest() // BLAUE LED TESTEN *****   + 5V  *****
{   a=0;
    while (a<4)
    {
       LedBl=1;
       wait_ms(t);
       LedBl=0;
       wait_ms(t);
       a=a++;
    }    
    LedBl=1;
}

// ********************  Motor Test **********************
void MotorTest()   // MOTOR TEST *******   + 12 V  *****
{
   a=0;
   MG1_EN=MG2_EN=1;
   Von=1;
   while (a<5)
   {
     MG1_F=MG2_F=1;  //vor fahren
     wait (1.5);
     MG1_F=MG2_F=0;
     MG1_R=MG2_R=1;   //retour fahren
     wait (1);
     MG1_R=MG2_R=0;
     a++;     
   }
   MG1_EN=MG2_EN=0;
   Von=0;    
}    

      
// ****************   TASTER TEST   ********************

// ****************************  RGB TEST ********************************
void RGBTest()         
{
    writeled(0x000000);      // setze alle LED AUS !
    writeled(0x000000);
    writeled(0x000000);      // 
    a=0;
    while(a<5)              // geht 5 mal durch die Schleife !
    {  
       writeled(0xFF0000);      // BLAU!
       wait(1);
       writeled(0x00FF00);       // ROT !
       wait (1);
       writeled(0x0000FF);       // GRÜN !
       wait(1);
       writeled(0x000000);       // Finster
       wait(1);
       wait(1); 
       a=a++;  
    }
}

void writeled(uint32_t leddata)
{      int i;
       for(i=0;i<24;i++)
       {
      //  writeledbit(((leddata>>i)&0x000001)==1); //lt jan
          writeledbit(((leddata>>i)&0x000001)==0x000001);
       }
}
void writeledbit(char wert)  // Funktion schreibe bit
{
    int j;
    if(wert)
    {   // kritische Zeiteinstellung !
        // hab einiges versucht -> leuchten nicht konstant !
        // bringen verschiedene Farben  nicht wiederholbares Ergebnis!
        RGB=1;            // schreibe eine 1
        for(j=0;j<5;j++)    //war 5 
        {
        __nop();    
        }
        RGB=0;
        for(j=0;j<1;j++)    // war 1
        {
        __nop();   
        }
    }
    else
    {
        RGB=1;            // schreiben eine 0
        for(j=0;j<1;j++)    // war 1
          {
          __nop();    
          }
        RGB=0;
        for(j=0;j<5;j++)    // war 5
          {
          __nop();   
          }
    }           
}
// ****************** LINE TEST **********************

/*
void LineTest()
{
    Von=1;
    EN_Line=1;
    T1=T2=T3=T4=T5=T6=T7=T8=0;
    a=0;
    while(a<4)
     {
        if (ISO1==1)
         { ledD2=1;         
           T1=1; 
         }  
         else ledD2=0;
        if (ISO2==1)
         { ledD1=1;         
           T2=1; 
         }  
         else ledD1=0;
        if (ISO3==1)
         { ledD4=1;         
           T3=1;
         }  
         else ledD4=0;
        if (ISO4==1)
         { ledD5=1;         
           T4=1;  
         }  
         else ledD5=0;
        if (ISO5==1)
         { ledD6=1;
           ledD8=1;          
           T5=1;
         }  
         else 
         { ledD6=0; 
           ledD8=0;
         }
         if (T1==T2==T3==T4==T5==1)
         {
          a++;
          T1=T2=T3=T4=T5=T6=T7=T8=0;   
         }    
                  
     }
     testOK(); 
}    
*/

// ********************   ENDE  *********************** 