/***********************************
name:   BERTL15_Test1
author: Enenkel 
description:
    D1_D4 Lauflicht
***********************************/
#include "mbed.h"

// 3,3 und 3,7V Schiene
DigitalOut LedD10 (P1_8);    // LED D10 bis D13 IO Definieren
DigitalOut LedD11 (P1_9);
DigitalOut LedD12 (P1_10);
DigitalOut LedD13 (P1_11);

I2C i2c(p28, p27);           // die Adressen des I2C Busses am uP 
                             // p28 -> SDA
                             // p27 -> SCL 

// 5V Schiene & Motor Spannung
DigitalOut Von (P1_2);       // SPANNUNG 10V & 5V 
DigitalOut LedBLUE(P1_28);   // Blaue LED unter dem B15
DigitalOut LedBL (P1_24);    //RGB LED
DigitalOut LedGR (P1_25);    //
DigitalOut LedRT (P1_23);    //  RT



void RT();
void BL();
void GR();
void WS();

void count();
void LedSt();
double counter1;
int a;
char btn;

int main() {
    a=1;
    btn = 0;
    Von=1;                // Motorspannung und 5V Schiene EIN  
    //     ****  Config PCA9555 I0 as output *******
    i2c.start();
       i2c.write(0x40);   // Adresse des PCA9555 = 40 
                          // das letzte Bit = 0 -> schreiben  0040 0000
       i2c.write(0x06);   // Befehl für das IO Port 0 -> siehe SCHEMA des PCA9555
       i2c.write(0x00);   // Schalte alle Pins des Ports als OUTPUT
    i2c.stop();    
 
   // RGB on
   LedGR=LedRT=LedBL=0;   // RGB LED = WEISS (inverse Logik) 
   
   // D10-D13 Lauflicht
   a=0;
   while (a<4) 
     {
     LedD10=1;
     wait (0.3);
     LedD10=0;
     LedD11=1;
     wait (0.3);
     LedD11=0;
     LedD12=1;
     wait (0.3);
     LedD12=0;
     LedD13=1;
     wait (0.3);
     LedD13=!LedD13;
     a=a++;
     }
   
   LedGR=LedRT=LedBL=1;      //RGB = AUS  damit blaue LED besser sichtbar wird
   // Blaue Unterboden LED Blinken (invers!) 
   a= 0;
   while (a<40)
      {
      LedBLUE = 0;  
      wait (0.1);
      LedBLUE = 1;
      wait (0.1);
      a=a++;
      } 
    
      
   // RGB TEST (Inverse Logik)
   LedRT=LedBL=LedGR=0 ;      // weis ON
   wait (0.5);
   a=0;
   while (a<7) 
    {
     LedRT = 0;               // rot  ON
     LedGR=LedBL=1;
     wait (0.5);
     LedGR = 0;               // grün ON
     LedRT=LedBL=1;
     wait (0.5);
     LedBL = 0;               // blau ON
     LedRT=LedGR=1;
     wait (0.5);
     a=a++;
     }  
     LedRT=LedGR=LedBL=1 ;    // RGB = AUS
     Von=0;                   // 5V ausschalten !
                              // sonst glimmt RT vom RGB !
                              // Rv vom RGB RT ev auf 330 Ohm
    //Taster und LED Test
    while(1) {
        counter1=1;
        btn=0;
        while(counter1<5000) {
            counter1=counter1++;
        
            // Einlesen der Taster und speichern unter btn
            i2c.start();
                            /* Das letzte Bit der Adresse entscheidet 
                               ob geschrieben oder gelesen wird. 
                               0 => schreiben;   1 => lesen  */
                i2c.write(0x40);    //Adresse & schreiben   0100 0000 
                i2c.write(0x01);    //aktivate Port 1        
       
            i2c.start();
                i2c.write(0x41);  // Adresse & LESEN    0100 0001  
                btn = i2c.read(0);// Einlesen des Ports 1 und speichern unter btn
            i2c.stop();
        
            // Schreiben auf Port 0 und damit auf die LED's
            i2c.start();
                i2c.write(0x40);  // Adresse & schreiben
                i2c.write(0x02);  // 
                i2c.write(~btn);  // schriebn auf Port 0 den INVERSEN Wert von btn
            i2c.stop();
        }
     } 
 }      