#include "RTC8563.h"
#include "mbed.h"
#include "const.h"
#include "Date.h"
#include "string.h"

char day_a, hour_a, minute_a, week_a;
char week_chr[7][4] = {"MON","TUE","WED","THU","FRI","SAT","SUN"};

Serial pc(USBTX, USBRX);
RTC8563 rtc(p28, p27);
Date date;

int main()
{
    rtc.init(15, 4, 16, 12, 16, 0, 4); // years, months, days, hours, minutes, seconds, weekday (1 == Monday)
    rtc.alarm(16, 12, 10, 4); // day, hour, min, weekday

    while(1) {
        
        // RTC Zeit Ausgabe
        pc.printf("RTC8563 TIME AND DATE:\n" );
        pc.printf("%02d.%02d.20%02d | %s\n", date.getDay(), date.getMonth(), date.getYear(), week_chr[date.getWeekday()]); // Date
        pc.printf("%02d:%02d:%02d\n", date.getHours(), date.getMinutes(), date.getSeconds()); // Time
        
        // RTC Alarm
        day_a = rtc.read(DAY_ALARM);
        hour_a = rtc.read(HOUR_ALARM);
        minute_a = rtc.read(MINUTE_ALARM);
        week_a = rtc.read(WEEKDAY_ALARM);

        pc.printf("RTC8563 ALARM:\n" );
        pc.printf("DAY: %02dth | %02d:%02d %s\n", day_a, hour_a, minute_a, week_chr[week_a]); // Alarm
        
        pc.printf("##############################################\n" );
        wait(0.5);
    }
}
