#include <mbed.h>
#include "OneWire_Methods.h"
#include "ds2781.h"

Serial pc(USBTX, USBRX);
DigitalInOut   one_wire_pin(PC_12);
int VoltageReading, CurrentReading;
float Voltage, Current;

int main() {

  while(1) {
      VoltageReading = ReadVoltage();
      Voltage = VoltageReading*0.00976; //Returns the voltage measured at the VIN input of the DS2781      *
 *                                      //in units of 9.76mV 
      CurrentReading = ReadCurrent();
      Current = CurrentReading/6400.0; //Returns the current measured through Rsns external to DS2781 in  *
 *                                     //units of 1.5625uV/Rsns. Positive current indicates discharge 
      pc.printf("\n\rVoltage = %0.3f, Current= %0.3f", Voltage, Current);
  }
}