/*
    Title:       Mbed Motor Controller
    Author:      Samuel.Walsh@manchester.ac.uk
    Date:        27/01/16
    Description: Using School of EEE Motor Driver Board and STM32F303K8 Nucleo32
    Unipolar PWM Controlling a DC Brushed Motor with PWM on D3, PWM is inverse so
    1.0 = motor off and 0.0 = motor full
 */

#include "mbed.h"


#define CURRENT_CHECK_PERIOD_US 50    //Checks ths current of the motor every 100us
#define TICKS_PER_REVOLUTION    12.0   //The encoder has 12 slots
#define TICK_CHECK_PERIOD_US    10000    //Checks ths speed every 10ms
#define TICKS_PER_SECOND_MAX    1800.0 //This was found through experimentation with motor, max speed = 8900RPM = ~1800 ticks per second 
#define TICKS_PER_SECOND_MIN    1*TICKS_PER_REVOLUTION  //This is equal to 1RPS (60RPM) at however many ticks per revolution
#define SETPOINT_RPM            4000   //Arbitrarily picked

/* Peripherals */
PwmOut motorPWM(D6);
AnalogOut  PWM_Duty_Cycle_DAC_Out(A5); //Used for plotting motor resonse on a scope
Ticker periodicTimer1;

//Peripherals used for debugging
Serial pc(USBTX, USBRX); // tx, rx  just used for debugging

float normalise(float real_min, float real_max, float scaled_min, float scaled_max, int value){
        return (((value - real_min) * (scaled_max - scaled_min)) / (real_max - real_min)) + scaled_min; 
}

void Print_Variables_To_PC(){
   //pc.printf("put whatever you want here to be sent to PC once a second %d, %d, %f",var1,var2,var3);
}

int main() {
    //Setup PWM
    motorPWM.period_us(100);  //Set up for 10KHz PWM Switching Frequency
    
    //Setup Debugging     
    periodicTimer1.attach(&Print_Variables_To_PC, 1.0);          //Display stuff on serial port once a second
    
    motorPWM = 0;
    PWM_Duty_Cycle_DAC_Out = motorPWM;
    
    float wait_time = 0.5;
    
    while(1) { 
        wait(wait_time);
        motorPWM = 0.1;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
        
        wait(wait_time);
        motorPWM = 0.2;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
        
        wait(wait_time);
        motorPWM = 0.3;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
        
        wait(wait_time);
        motorPWM = 0.4;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
        
        wait(wait_time);
        motorPWM = 0.5;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
        
        wait(wait_time);
        motorPWM = 0.6;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
        
        wait(wait_time);
        motorPWM = 0.7;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
        
        wait(wait_time);
        motorPWM = 0.8;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
        
        wait(wait_time);
        motorPWM = 0.9;
        PWM_Duty_Cycle_DAC_Out = motorPWM;
    }
          
}
