/*
Adafruit LCD STM32F401RE Nucleo Example

This code was adapted from ILI9341 TFT LCD library found on mbed.org
Can't find original code right now but it's on mbed somewhere.

For use with Adafruit 2.8 inch Capacative ILI9341 LCD 
Please note that the touch screen is not used in this example

Author Samuel.Walsh@Manchester.ac.uk (ported slightly, didn't write)
*/


#include "SPI_TFT_ILI9341.h"
#include "Arial12x12.h"
#include "Neu42x35.h"
#include "mbed.h"

/* Adafruit 2.8" Cap Touch LCD Panel - Arduino Pinout

    FUNCTION     MBED  NUCLEO (pins) 
    =====================================
    TFT   SCLK = D13 = PA_5 (SPI1 SCLK)
    TFT   MISO = D12 = PA_6 (SPI1 MISO)
    TFT   MOSI = D11 = PA_7 (SPI1 MOSI)
    TFT   CS     = D10 = PB_6
    TFT   DC   = D9  = PC_7

    CARD  CS   = D4  = PB_5

    TOUCH SCL  = D15 = PB8  (I2C1_SCL)
    TOUCH SDA  = D14 = PB_9 (I2C1 SDA)
    
    //D7 = PA_8 = TPIRQ
    */


int main(void)
{
    //Setup pins and hardware
    //DigitalIn shellSwitch(D6); // PB_0 (normally pulled high)
    I2C i2c(I2C_SDA, I2C_SCL); // SDA, SCL
    SPI_TFT_ILI9341 TFT(PA_7, PA_6, PA_5, PB_6, PA_8, PC_7,"TFT");  // mosi, miso, sclk, cs, reset, dc
    DigitalOut lcdOn(PC_7); //not sure this one is correct PC_7 function is unknown
    
    //Init display SPI
    lcdOn = 1;
    
    TFT.claim(stdout);  
    TFT.set_orientation(1);
    TFT.background(White);    // set background to black
    TFT.foreground(Black);    // set chars to white
    TFT.cls();                // clear the screen
 

    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(0,0);

    double var1 = 123.32;
    double var2 = 123.4;
    double var3 = 87; //example variables to display
    
            // Use large fonts to display title
            TFT.background(White);
            TFT.foreground(Blue);
            TFT.locate(60, 50);
            TFT.set_font((unsigned char *) Neu42x35);
            TFT.printf("Title Here");
    
    while(1){
            // Display variable 1 in large and red
            TFT.background(White);
            TFT.foreground(Red);
            TFT.locate(100, 120);
            TFT.set_font((unsigned char *) Neu42x35);
            TFT.printf("%.02f",var1);

            // Smaller font in blue box for variable 2
            TFT.fillrect(0,185,320,216,Blue);
            TFT.background(Blue);
            TFT.foreground(White);
            TFT.locate(0,187);
            TFT.set_font((unsigned char*) Arial12x12);
            TFT.printf("Variable 2 = %.02f", var2);
            
            //Bottom black box for variable 3
            TFT.locate(0, 218);
            TFT.background(Black);
            TFT.foreground(White);
            TFT.set_font((unsigned char*) Arial12x12);
            TFT.printf("Variable 3: %0.2f", var3);
        
            wait(0.5); //Refresh the LCD once every half second
            
            //Change the variable values on refresh
            var1 += 0.01;
            var2 += 1;
            var3 += 0.5;
    }   
}


    
  