//
// NET_DECL.H - header file for other ebs header files
//
//
// EBSnet - RTIP
//
//  $Author: YOHANNES $
//  $Date: 2007/11/21 12:00:00 $
//  $Name:  $
//  $Revision: 1.1 $
//
// Copyright EBSnet Inc. , 2007
// All rights reserved.
// This code may not be redistributed in source or linkable object form
// without the consent of its author.
//
// Module description:
// 
//

#ifndef _NET_DECL_H_
#define _NET_DECL_H_

#include <tinyhal.h>
#include "network_defines.h"

#ifdef PLATFORM_DEPENDENT__NETWORK_MEMORY_POOL__SIZE
#define NETWORK_MEMORY_POOL__SIZE PLATFORM_DEPENDENT__NETWORK_MEMORY_POOL__SIZE
#else
#define NETWORK_MEMORY_POOL__SIZE NETWORK_MEMORY_POOL__SIZE__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_0__NUM_PACKETS
#define NETWORK_PACKET_POOL_0__NUM_PACKETS PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_0__NUM_PACKETS
#else
#define NETWORK_PACKET_POOL_0__NUM_PACKETS NETWORK_PACKET_POOL_0__NUM_PACKETS__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_1__NUM_PACKETS
#define NETWORK_PACKET_POOL_1__NUM_PACKETS PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_1__NUM_PACKETS
#else
#define NETWORK_PACKET_POOL_1__NUM_PACKETS NETWORK_PACKET_POOL_1__NUM_PACKETS__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_2__NUM_PACKETS
#define NETWORK_PACKET_POOL_2__NUM_PACKETS PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_2__NUM_PACKETS
#else
#define NETWORK_PACKET_POOL_2__NUM_PACKETS NETWORK_PACKET_POOL_2__NUM_PACKETS__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_3__NUM_PACKETS
#define NETWORK_PACKET_POOL_3__NUM_PACKETS PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_3__NUM_PACKETS
#else
#define NETWORK_PACKET_POOL_3__NUM_PACKETS NETWORK_PACKET_POOL_3__NUM_PACKETS__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_4__NUM_PACKETS
#define NETWORK_PACKET_POOL_4__NUM_PACKETS PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_4__NUM_PACKETS
#else
#define NETWORK_PACKET_POOL_4__NUM_PACKETS NETWORK_PACKET_POOL_4__NUM_PACKETS__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_5__NUM_PACKETS
#define NETWORK_PACKET_POOL_5__NUM_PACKETS PLATFORM_DEPENDENT__NETWORK_PACKET_POOL_5__NUM_PACKETS
#else
#define NETWORK_PACKET_POOL_5__NUM_PACKETS NETWORK_PACKET_POOL_5__NUM_PACKETS__default
#endif

//--//

#ifdef PLATFORM_DEPENDENT__NETWORK_NUM_IFACES
#define NETWORK_NUM_IFACES PLATFORM_DEPENDENT__NETWORK_NUM_IFACES
#else
#define NETWORK_NUM_IFACES NETWORK_NUM_IFACES__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_NUM_DEVICES
#define NETWORK_NUM_DEVICES PLATFORM_DEPENDENT__NETWORK_NUM_DEVICES
#else
#define NETWORK_NUM_DEVICES NETWORK_NUM_DEVICES__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_MULTICAST_LIST_SIZE
#define NETWORK_MULTICAST_LIST_SIZE PLATFORM_DEPENDENT__NETWORK_MULTICAST_LIST_SIZE
#else
#define NETWORK_MULTICAST_LIST_SIZE NETWORK_MULTICAST_LIST_SIZE__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_ROUTINGTABLE_SIZE
#define NETWORK_ROUTINGTABLE_SIZE PLATFORM_DEPENDENT__NETWORK_ROUTINGTABLE_SIZE
#else
#define NETWORK_ROUTINGTABLE_SIZE NETWORK_ROUTINGTABLE_SIZE__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_ARP_NUM_TABLE_ENTRIES
#define NETWORK_ARP_NUM_TABLE_ENTRIES PLATFORM_DEPENDENT__NETWORK_ARP_NUM_TABLE_ENTRIES
#else
#define NETWORK_ARP_NUM_TABLE_ENTRIES NETWORK_ARP_NUM_TABLE_ENTRIES__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_FRAG_TABLE_SIZE
#define NETWORK_FRAG_TABLE_SIZE PLATFORM_DEPENDENT__NETWORK_FRAG_TABLE_SIZE
#else
#define NETWORK_FRAG_TABLE_SIZE NETWORK_FRAG_TABLE_SIZE__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_NAT_NUM_ENTRIES
#define NETWORK_NAT_NUM_ENTRIES PLATFORM_DEPENDENT__NETWORK_NAT_NUM_ENTRIES
#else
#define NETWORK_NAT_NUM_ENTRIES NETWORK_NAT_NUM_ENTRIES__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_TCP_NUM_PORTS__SUPPORTED
#define NETWORK_TCP_NUM_PORTS__SUPPORTED PLATFORM_DEPENDENT__NETWORK_TCP_NUM_PORTS__SUPPORTED
#else
#define NETWORK_TCP_NUM_PORTS__SUPPORTED NETWORK_TCP_NUM_PORTS__SUPPORTED__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_UDP_NUM_PORTS__SUPPORTED
#define NETWORK_UDP_NUM_PORTS__SUPPORTED PLATFORM_DEPENDENT__NETWORK_UDP_NUM_PORTS__SUPPORTED
#else
#define NETWORK_UDP_NUM_PORTS__SUPPORTED NETWORK_UDP_NUM_PORTS__SUPPORTED__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_DHCP_RETRIES
#define NETWORK_DHCP_RETRIES PLATFORM_DEPENDENT__NETWORK_DHCP_RETRIES
#else
#define NETWORK_DHCP_RETRIES NETWORK_DHCP_RETRIES__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_DHCP_TIMEOUT
#define NETWORK_DHCP_TIMEOUT PLATFORM_DEPENDENT__NETWORK_DHCP_TIMEOUT
#else
#define NETWORK_DHCP_TIMEOUT NETWORK_DHCP_TIMEOUT__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_IGMPV1_MAX_DELAY
#define NETWORK_IGMPV1_MAX_DELAY PLATFORM_DEPENDENT__NETWORK_IGMPV1_MAX_DELAY
#else
#define NETWORK_IGMPV1_MAX_DELAY NETWORK_IGMPV1_MAX_DELAY__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_ARP_REQ_TIMEOUT
#define NETWORK_ARP_REQ_TIMEOUT PLATFORM_DEPENDENT__NETWORK_ARP_REQ_TIMEOUT
#else
#define NETWORK_ARP_REQ_TIMEOUT NETWORK_ARP_REQ_TIMEOUT__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_ARP_MAX_RETRIES
#define NETWORK_ARP_MAX_RETRIES PLATFORM_DEPENDENT__NETWORK_ARP_MAX_RETRIES
#else
#define NETWORK_ARP_MAX_RETRIES NETWORK_ARP_MAX_RETRIES__default
#endif 

#ifdef PLATFORM_DEPENDENT__NETWORK_ARP_RES_TIMEOUT
#define NETWORK_ARP_RES_TIMEOUT PLATFORM_DEPENDENT__NETWORK_ARP_RES_TIMEOUT
#else
#define NETWORK_ARP_RES_TIMEOUT NETWORK_ARP_RES_TIMEOUT__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_DNS_MIN_DELAY
#define NETWORK_DNS_MIN_DELAY PLATFORM_DEPENDENT__NETWORK_DNS_MIN_DELAY
#else
#define NETWORK_DNS_MIN_DELAY NETWORK_DNS_MIN_DELAY__default
#endif 

#ifdef PLATFORM_DEPENDENT__NETWORK_DNS_MAX_DELAY
#define NETWORK_DNS_MAX_DELAY PLATFORM_DEPENDENT__NETWORK_DNS_MAX_DELAY
#else
#define NETWORK_DNS_MAX_DELAY NETWORK_DNS_MAX_DELAY__default
#endif

#ifdef PLATFORM_DEPENDENT__NETWORK_DNS_RETRIES
#define NETWORK_DNS_RETRIES PLATFORM_DEPENDENT__NETWORK_DNS_RETRIES
#else
#define NETWORK_DNS_RETRIES NETWORK_DNS_RETRIES__default
#endif

//--// RAM size estimate macro

// The following values are from the EBSNet RAM usage spreadsheet
#define _NETWORK_SIZEOF_NONE                4
// mclist_ip, mclist_eth, mcast_cnt, report_timer, last_host_toreply
#define _NETWORK_SIZEOF_MCLISTSIZE          (4*3)
#define _NETWORK_SIZEOF_DCU                 112
#define _NETWORK_SIZEOF_IFACE               (380 + 28 + 84 + 4 + 4 + 16 + 16 + (8 * 8))
#define _NETWORK_SIZEOF_ROUTINGTABLE        56
#define _NETWORK_SIZEOF_ARP_ENTRY           28
#define _NETWORK_SIZEOF_TCPPORT             (472 + 16 + (8*8))
#define _NETWORK_SIZEOF_UDPPORT             (272 + 16 + (8*8))
#define _NETWORK_SIZEOF_FRAG_ENTRY          20
#define _NETWORK_SIZEOF_NAT_ENTRY           24 
#define _NETWORK_SIZEOF_PACKET_OVERHEAD     1

#define _NETWORK_TOTAL_PACKET_COUNT        (NETWORK_PACKET_POOL_0__NUM_PACKETS + \
                                            NETWORK_PACKET_POOL_1__NUM_PACKETS + \
                                            NETWORK_PACKET_POOL_2__NUM_PACKETS + \
                                            NETWORK_PACKET_POOL_3__NUM_PACKETS + \
                                            NETWORK_PACKET_POOL_4__NUM_PACKETS + \
                                            NETWORK_PACKET_POOL_5__NUM_PACKETS)
                                            

#define NETWORK_RAM_SIZE_ESTIMATE() (\
    _NETWORK_SIZEOF_NONE + \
    NETWORK_MULTICAST_LIST_SIZE        * (_NETWORK_SIZEOF_MCLISTSIZE) + \
    NETWORK_PACKET_POOL_0__NUM_PACKETS * (NETWORK_PACKET_POOL_0__PACKET_SIZE + _NETWORK_SIZEOF_DCU) + \
    NETWORK_PACKET_POOL_1__NUM_PACKETS * (NETWORK_PACKET_POOL_1__PACKET_SIZE + _NETWORK_SIZEOF_DCU) + \
    NETWORK_PACKET_POOL_2__NUM_PACKETS * (NETWORK_PACKET_POOL_2__PACKET_SIZE + _NETWORK_SIZEOF_DCU) + \
    NETWORK_PACKET_POOL_3__NUM_PACKETS * (NETWORK_PACKET_POOL_3__PACKET_SIZE + _NETWORK_SIZEOF_DCU) + \
    NETWORK_PACKET_POOL_4__NUM_PACKETS * (NETWORK_PACKET_POOL_4__PACKET_SIZE + _NETWORK_SIZEOF_DCU) + \
    NETWORK_PACKET_POOL_5__NUM_PACKETS * (NETWORK_PACKET_POOL_5__PACKET_SIZE + _NETWORK_SIZEOF_DCU) + \
    _NETWORK_TOTAL_PACKET_COUNT        * _NETWORK_SIZEOF_PACKET_OVERHEAD     + \
    NETWORK_NUM_IFACES                 * _NETWORK_SIZEOF_IFACE        + \
    NETWORK_ROUTINGTABLE_SIZE          * _NETWORK_SIZEOF_ROUTINGTABLE + \
    NETWORK_ARP_NUM_TABLE_ENTRIES      * _NETWORK_SIZEOF_ARP_ENTRY    + \
    NETWORK_TCP_NUM_PORTS__SUPPORTED   * _NETWORK_SIZEOF_TCPPORT      + \
    NETWORK_UDP_NUM_PORTS__SUPPORTED   * _NETWORK_SIZEOF_UDPPORT      + \
    NETWORK_FRAG_TABLE_SIZE            * _NETWORK_SIZEOF_FRAG_ENTRY   + \
    NETWORK_NAT_NUM_ENTRIES            * _NETWORK_SIZEOF_NAT_ENTRY )    \


typedef char NETWORK_COMPILE_TIME_ASSERT[NETWORK_MEMORY_POOL__SIZE - NETWORK_RAM_SIZE_ESTIMATE()];


#endif //_NET_DECL_H_

