#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

PwmOut output(D2);
Serial pc(USBTX, USBRX);

float  random_number;

void Configure_System_Clocks(void);

int main() {
    
    Configure_System_Clocks();
    output.period_us(100);  // 100 kHz Period PWM Output
    output.write(0.50);    // 50% Duty Cycle
    
    srand(time(NULL));     // Seed the rand function to intialise it
    
    while(1){
        //random_number = (float)rand()/(float)RAND_MAX;  // Generate random number between 0 and 1
        random_number = 0.3;
        if(random_number <= 0.5f)
        {
            output.write(0.5);
        }
        else
        {
            output.write(0);
        }
    }
}

void Configure_System_Clocks(void){
    PWR->CR |= PWR_CR_VOS_1;                                                                    //Voltage scale 2
     
    RCC->APB1ENR |= RCC_APB1ENR_PWREN;                                              //APB1 Clock power enable
    
    RCC->CR |= RCC_CR_HSEON;
    while((RCC->CR & RCC_CR_HSERDY) == 0){};                                    //Wait for HSE Ready
    
  //RCC->CFGR |= RCC_CFGR_MCO1PRE_0;        
    RCC->CFGR |= RCC_CFGR_MCO1;                                                 //MCO1 OUTPUT = 0=,1=0x02
        
    FLASH->ACR |= FLASH_ACR_PRFTEN;                                             //Enable Prefetch Buffer
    FLASH->ACR |= FLASH_ACR_ICEN;                                                       //Instruction Cache Enable
    FLASH->ACR |= FLASH_ACR_DCEN;                                                       //Data Cache Enable
    FLASH->ACR |= FLASH_ACR_LATENCY_2WS;                                            //Flash 2 Wait State
        
    RCC->CFGR |= RCC_CFGR_HPRE_DIV1;                                                //AHB1PRESCALER = HCLK = SYSCLK  1=0x00
    RCC->CFGR |= RCC_CFGR_PPRE1_DIV2;                                               //APB1PRESCALER = HCLK/2  2=0x04
    RCC->CFGR |= RCC_CFGR_PPRE2_DIV1;                                               //APB2PRESCALER = HCLK/1
        
    RCC->CR &= ~RCC_CR_PLLON;
    
  RCC->PLLCFGR = (4ul                       |                // PLL_M =  4
                 (84ul << 6)                |                // PLL_N = 84
                 (0ul << 16)                |                // PLL_P =  2
                 (RCC_PLLCFGR_PLLSRC_HSE)   |                // PLL_SRC = HSE
                 (7ul << 24));                               // PLL_Q =   7
    
    RCC->CR |= RCC_CR_PLLON;                                 // Enable PLL
    while((RCC->CR & RCC_CR_PLLRDY) == 0) __NOP();           // Wait till PLL is ready

    RCC->CFGR &= ~RCC_CFGR_SW;                               // Select PLL as system clock source
    RCC->CFGR |=  RCC_CFGR_SW_PLL;
    while ((RCC->CFGR & RCC_CFGR_SWS) != RCC_CFGR_SWS_PLL);  // Wait till PLL is system clock src
    //System clock should be setup for 84MHz, lets output this to MCO1
    
     
    //Setup PA8 MCO1 as GPIO Output 
    RCC->AHB1ENR   |= RCC_AHB1ENR_GPIOAEN;                    //Enable GPIOA Clock
    GPIOA->MODER   |= GPIO_MODER_MODER8_1;                    //GPIO_MODER_MODER8_1 = 2 = Alternate Function Pin
    GPIOA->OTYPER  |= (0ul<<8);                               //Push Pull Output
    GPIOA->OSPEEDR |= GPIO_OSPEEDER_OSPEEDR8;                 //High Speed Output
    GPIOA->PUPDR     |= (0ul << 2*8);                           //No Pullup Pulldown
    GPIOA->AFR[1]  |= (0ul << 0);                                           //AFRH register holds P8-P15 AF Config, 0x00 = AF0 for PORT8 Which from Datasheet Table 9 = MCO1                
}