#include "mbed.h"
#include "USBSerial.h"

//this program uses timers to time how long the signal is high and how long the signal is low. this program manages to accurately read the signal within 1-2us on each pulsewidth
// giving around a 3us loss in accuracy for the whole period. 
// the program starts the timer on the rising edge of the signal and stops the timer on teh falling edge. I found that
// my readings are more accurate if i read the negative pulsewidth on a seperate pin and (int_pin_2) and I put this through a NOT gate.
// the NOT gate would liekly introduce some propagation delay but after monitoring the signal on the scope this didnt seem to be the case.
// Ideally if I could take a sample of the timer values and take an average my results would be better. After trying this, adding more code
// decreased teh accuracy of the results as more lines of code needed to be executed.

USBSerial serial;
InterruptIn int_pin(P1_14);
InterruptIn int_pin_2(P1_24);
Timer t1;
Timer t2;
Ticker display;

int t_period = 0;                   // This is the period between interrupts in microseconds
int t_period_rise = 0;
int t_period_fall = 0;
int t_freq = 0;
int results[30];
int i =0;
float k =0;

void rise()
{
   t1.start();      // start rising edge timer
    }
    
void fall()
{
    t1.stop();  // stop rising edge timer
    t_period_rise = t1.read_us();    // read timer in us
    t1.reset();  
    }

void rise_2()
{
    t2.start();     //start falling edge timer (on rising edge of pulse after inverted by NOT gate)
}
void fall_2()
{
    t2.stop();
    t_period_fall = t2.read_us();
    t2.reset();
    }
      
void disp()
{
    
  // did have serial print here
    
    }




      
int main() {
     
    
    int_pin.rise(&rise);               // Set up the interrupt for rising edge    
    int_pin.fall(&fall);
    int_pin_2.rise(&rise_2);
    int_pin_2.fall(&fall_2);
    //diaplay.attach(&disp, 2)
           
    while (1) {
         i = ((t_period_rise) + (t_period_fall));      
         k = (1/(float)i)*1000000;
        wait(3);
         
         serial.printf("\rPeriod is %d \n", i);
         serial.printf("\rFrequency is %.2f \n", k);
         serial.printf("\rPeriod_rise is %d \n", t_period_rise);
         serial.printf("\rPeriod_fall is %d \n", t_period_fall);
    
    }

}

//}
