 /* mbed Library - PulseWidthCapture
 * Copyright (c) 2014
 * released under MIT license http://mbed.org/licence/mit
 */
 
/***********************************************************************//**
 * @file        PulseWidthCapture.h
 * @brief       Header file for the PulseWidthCapture library. 
 * @version     0.0
 * @date        03 Dec 2014
 * @author      Callum Ellor
 **************************************************************************/
/***************************************************************************
 * Revision     Date        Comments
 *----------    --------    -----------------------------------------------
 *
 *  0.0         03/12/14    Initial creation
 ***************************************************************************/

#ifndef CAPTURET0_H
#define CAPTURET0_H

/* Includes ------------------------------------------------------------------- */
#include "mbed.h"

/* Public Types --------------------------------------------------------------- */


/* Public Functions ----------------------------------------------------------- */
/** Capture_Public_Functions Capture Public Functions
*/
class Capture {
public:

/* Create a Capture object and configure it */
Capture(void);

/* Start capturing data. */
void Start_1(void);
void Start_2(void);

/* Wait function */
void Wait(void);

/* Debug function */
unsigned int Debug(void);

/* Public Macros -------------------------------------------------------------- */

private:
static void _Fall_ISR(void);
static void _Rise_ISR(void);
static void _Wait_ISR(void);
void Fall_ISR(void); 
void Rise_ISR(void);  
void Wait_ISR(void);  
static Capture *instance;
const char * freq_unit;
const char * rise_sec_unit;
const char * fall_sec_unit;
const char * per_sec_unit;
float rise, rise1, fall, fall1, period, period1, freq, freq1, ADCdata;
unsigned int debug;    
                                        
/* Private Macros ------------------------------------------------------------- */
/* --------------------- BIT DEFINITIONS -------------------------------------- */
/* Timer Capture Register Definitions --------------------- */

/*********************************************************************//**
 * Macro defines for CT32B0->IR Interrupt tegister
 **********************************************************************/
#define CT32B0_IR_CR0INT                   ((uint32_t)(1<<4))        /**< Interrupt flag for capture channel 0 */
#define CT32B0_IR_CR1INT                   ((uint32_t)(1<<6))        /**< Interrupt flag for capture channel 1 */

/*********************************************************************//**
 * Macro defines for CT32B1->IR Interrupt tegister
 **********************************************************************/
#define CT32B1_IR_CR0INT                   ((uint32_t)(1<<4))        /**< Interrupt flag for capture channel 0 */
#define CT32B1_IR_CR1INT                   ((uint32_t)(1<<5))        /**< Interrupt flag for capture channel 1 */

/*********************************************************************//**
 * Macro defines for CT16B0->IR Interrupt tegister                  
 **********************************************************************/
#define CT16B0_IR_MR0INT                   ((uint32_t)(1<<0))        /**< Interrupt flag for Match channel 0 */

/*********************************************************************//**
 * Macro defines for IOCON->PIO1_29 register bits LPC11U24   page 125
 **********************************************************************/
#define P1_29_PIN_PULL_UP                     2UL
#define P1_29_PIN_REPEATER                    3UL
#define P1_29_PIN_NORESISTOR                  0UL
#define P1_29_PIN_PULL_DOWN                   1UL 

/* FUNC bits */                                                       // define what fucntion the pin should be set up in
#define PORT_PIO1_29                          0UL
#define SCKO                                  1UL
#define CT32B0_CAP1                           2UL

/* MODE bits */
#define P1_29_CAP_PULLUP                 ((uint32_t)(PIN_PULL_UP<<3))          // Pull up on the CT32B0_CAP1 input pin

/*********************************************************************//**
 * Macro defines for IOCON->PIO0_12 register bits LPC11U24      page 94
 **********************************************************************/
#define P0_12_PIN_PULL_UP                     2UL
#define P0_12_PIN_REPEATER                    3UL
#define P0_12_PIN_NORESISTOR                  0UL
#define P0_12_PIN_PULL_DOWN                   1UL 

/* FUNC bits */
#define PIO0_12                               1UL                     // define what fucntion the pin should be set up in
#define ADL                                   2UL
#define CT32B1_CAP0                           3UL             

#define ADMODE                           ((uint32_t)(1<<7))           // Set to digital function mode to allow capture input on this pin
#define FILTR                            ((uint32_t)(1<<8))    

/* MODE bits */
#define P0_12_CAP_PULLUP                 ((uint32_t)(PIN_PULL_UP<<3))          // Pull up on the CT32B0_CAP1 input pin

/*********************************************************************//**
 * Macro defines for SYSCON->SYSAHBCLKDIV register  bits LPC11U24      page 30
 **********************************************************************/
#define CT32B0_CLK_ENABLE          ((uint32_t)(1<<9))        /**< CT32B0 clock enable */ 

#define CT32B1_CLK_ENABLE          ((uint32_t)(1<<10))

#define CT16B0_CLK_ENABLE          ((uint32_t)(1<<7))
/*********************************************************************//**
 * Macro defines for CT32B0->TCR register  bits LPC11U24                page 353
 **********************************************************************/
#define CT32B0_TCR_CEN                         1UL

/*********************************************************************//**
 * Macro defines for CT32B1->TCR register  bits LPC11U24                page 353
 **********************************************************************/
#define CT32B1_TCR_CEN                          1UL

/*********************************************************************//**
 * Macro defines for CT16B0->TCR register  bits LPC11U24                page 335
 **********************************************************************/
#define CT16B0_TCR_CEN                          1UL

/*********************************************************************//**
 * Macro defines for CT32B0->CCR register  bits LPC11U24                page 357
 **********************************************************************/
#define CCR_CAP1RE                     ((uint32_t)(1<<6)) 
#define CCR_CAP1FE                     ((uint32_t)(1<<7))
#define CCR_CAP1I                      ((uint32_t)(1<<8))  

/*********************************************************************//**
 * Macro defines for CT32B1->CCR register  bits LPC11U24                page 356
 **********************************************************************/
#define CCR_CAP0RE                     ((uint32_t)(1<<0)) 
#define CCR_CAP0FE                     ((uint32_t)(1<<1))
#define CCR_CAP0I                      ((uint32_t)(1<<2))  

/*********************************************************************//**
 * Macro defines for CT32B0->CTCR register  bits LPC11U24               page  361
 **********************************************************************/
#define CT32B0_CTCR_CTM_TIMER                  0UL
#define CT32B0_CTCR_ENCC                       ((uint32_t)(1<<4))
#define CT32B0_CTCR_SEICC_CAP1RE               ((uint32_t)(4<<5))
#define CT32B0_CTCR_SEICC_CAP1FE               ((uint32_t)(5<<5))


/*********************************************************************//**
 * Macro defines for CT32B1->CTCR register  bits LPC11U24               page 362
 **********************************************************************/
#define CT32B1_CTCR_CTM_TIMER                  0UL
#define CT32B1_CTCR_ENCC                       ((uint32_t)(1<<4))
#define CT32B1_CTCR_SEICC_CAP0RE               ((uint32_t)(0<<5))          //CT32B1_CAP0
#define CT32B1_CTCR_SEICC_CAP0FE               ((uint32_t)(1<<5))

/*********************************************************************//**
 * Macro defines for CT16B0->MCR register  bits LPC11U24               page 337
 **********************************************************************/
#define CT16B0_MR0I                            ((uint32_t)(1<<0))
#define CT16B0_MR0R                            ((uint32_t)(1<<1))

}; // End of Capture class information
#endif /* CAPTURE_H */
/* --------------------------------- End Of File ------------------------------ */
