/*********************************************************************************************************************** 
This library has been created to create a new wait function that uses the 16 bit Timer 1 rather that the traditional 32 Bit Timer 0.
This library is intended for use with the 'TextLCD_16x4' Library to get the lcd to work alongside the 'PulseWidthCapture' Program.

Created by
Callum Ellor
**************************************************************************************************************************/

#include "mbed.h"
#include "LCD_Wait.h"

LCD_Wait::LCD_Wait(void)        //LCD_Wait constructor
{   

    LPC_SYSCON->SYSAHBCLKCTRL |=   CT16B1_CLK_ENABLE;       // setup system clock to enable 16 bit Timer 1 Page 30 of user manual
    
    LPC_CT16B1->PR  =  48000;                               // Set prescale value to give 1ms clock.
                     
}
           
void LCD_Wait::Wait(float num_wait) {       // wait function
    
    LPC_CT16B1->TC = 0;                     //set Timer Counter register to 0

    // Start the timer
    LPC_CT16B1->TCR =  CT16B1_TCR_CEN; // enable
                    
    // blocking while loop that waits for the timer counter to exceed the set value
    // If another interrupt fires during this while loop, this Wait function might take a little longer than expected

      while(LPC_CT16B1->TC < num_wait);
    
 }   
    
