#include "mbed.h"

#define ATMEGA88A 1
#include "AVRISP.h"

#define FUSE_LOW            0xD0
#define FUSE_HIGH           0xD9
#define FUSE_EXTENDED       0xFF
#define LOCK_BYTE           0xFF

//most chips use by default the internal 8Mhz clock with DIV8 fuse so 1Mhz seems a good starting point
#define TARGET_CLK 1000000L

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);

void ProgressLed()
{
    led1 = !led1;
    pc.printf(".");
}

#define ERROR -1

int main()
{
    int result = ERROR;
    uint8_t  signatureByte1 = 0xff,signatureByte2 = 0xff,signatureByte3 = 0xff;
    bool ProgMode = false;
    AVRISP *avrisp = NULL;
    LocalFileSystem local("local");
    FILE * hexFile = fopen("/local/avr.hex","r");
    
    if(!hexFile){
      pc.printf("Unable to load avr.hex file\n");
      goto exit;
    }
      
    avrisp = new AVRISP(p5,p6,p7,p8, TARGET_CLK, PAGE_SIZE, &ProgressLed);
    //pc.printf("Press any button to program the AVR.\n");
    //char c = pc.getc();
    
    pc.printf("Enter Programming Mode: ");
    ProgMode = avrisp->EnableProgrammingMode();
    if(ProgMode) {
        pc.printf(" Successful.\n");
    } else {
        pc.printf(" Failed.\n");
        goto exit;
    }
    
    signatureByte1 = avrisp->ReadChipSignatureByte( AVRISP::eSB1 );
    signatureByte2 = avrisp->ReadChipSignatureByte( AVRISP::eSB2 );
    signatureByte3 = avrisp->ReadChipSignatureByte( AVRISP::eSB3 );
    if ( signatureByte1 != SIGNATURE_BYTE_1 || signatureByte2 != SIGNATURE_BYTE_2 || signatureByte3 != SIGNATURE_BYTE_3 ) {
        pc.printf("Chip signature mismatch 0x%02x 0x%02x 0x%02x\n",signatureByte1,signatureByte2,signatureByte3);        
        goto exit;
    }
    
    pc.printf("Erasing Chip: ");
    avrisp->ChipErase();
    pc.printf(" Done\n");    
 
    pc.printf("Programing Flash:");
    if(avrisp->ProgramFlash(hexFile))   {            
        pc.printf(" Complete.\n");
        //verify programming
        pc.printf("Verifying Flash:");
        rewind(hexFile);
        if( avrisp->VerifyFlash(hexFile) )  {
            pc.printf(" Complete.\n");                
        } else {
            pc.printf(" Failed.\n");
            goto exit;
        }
    } else {
        pc.printf("Failed.\n");
    }
    
    //fuses
    /*pc.printf("Write Fuse Low Byte.\n");
    avrisp->WriteFuse(AVRISP::eFTLo, FUSE_LOW);
    pc.printf("Fuse Low Byte Readback = %x.\n",avrisp->ReadFuse(AVRISP::eFTLo));
    
    pc.printf("Write Fuse High Byte.\n");
    avrisp->WriteFuse(AVRISP::eFTHi, FUSE_HIGH);
    pc.printf("Fuse High Byte Readback = %x.\n",avrisp->ReadFuse(AVRISP::eFTHi));
    
    pc.printf("Write Fuse Extended Byte.\n");
    avrisp->WriteFuse(AVRISP::eFTEx, FUSE_EXTENDED);
    pc.printf("Fuse Extended Byte Readback = %x.\n",avrisp->ReadFuse(AVRISP::eFTEx));
    
    pc.printf("Write Lock Byte.\n");
    avrisp->WriteFuse( AVRISP::eFTLock, LOCK_BYTE);
    pc.printf("Lock Byte Readback = %x.\n",avrisp->ReadFuse(AVRISP::eFTLock));*/
    
    avrisp->LeaveProgrammingMode();

    while(true)
      __WFI();//do something nice

exit:    
    if(ProgMode)
        avrisp->LeaveProgrammingMode();
    
    if(avrisp)
        delete avrisp;
    
    if (hexFile)
        fclose(hexFile);    
    
    return result;
}
