//****************************************************************************/
// Description:
//
//  Program AVR chips with the AVR910 ISP (in-system programming) protocol,
//  using an mbed.
//
// This is a wrapper for AVR_ISP_Programmer_v2
//
//****************************************************************************/

#ifndef AVRISP_H
#define AVRISP_H

//****************************************************************************/
// Includes
//****************************************************************************/
#include "mbed.h"

//****************************************************************************/
// Definations for: ATMEGA1284p
//****************************************************************************/
#if defined(ATMEGA1284P)
#define SIGNATURE_BYTE_1    0x1E
#define SIGNATURE_BYTE_2    0x97
#define SIGNATURE_BYTE_3    0x05
#define PAGE_SIZE           64
#define NUM_PAGE            512
//****************************************************************************/
// Definations for: ATMEGA88A
//****************************************************************************/
#elif defined(ATMEGA88A)
#define SIGNATURE_BYTE_1    0x1E
#define SIGNATURE_BYTE_2    0x93
#define SIGNATURE_BYTE_3    0x0A
#define PAGE_SIZE           32
#define NUM_PAGE            128
#endif

class AVRISP
{
    public:
    typedef enum _SignatureByte{
        eSB1 = 0x00,
        eSB2 = 0x01,
        eSB3 = 0x02        
        } SignatureByte;
        
    typedef enum _FuseType{
        eFTLo,
        eFTHi,
        eFTEx,
        eFTLock,
        } FuseType;
        
    typedef void(*PRGCB)(void);
        
        AVRISP(PinName mosi, PinName miso, PinName sclk, PinName reset, uint32_t spiClk, uint16_t pageSize, PRGCB pCB = NULL);
        virtual ~AVRISP();
        
        bool EnableProgrammingMode();
        void LeaveProgrammingMode();
        void ChipErase();
        
        bool ProgramFlash(FILE *hexFile);
        bool VerifyFlash(FILE *hexFile);
        
        
        uint8_t ReadChipSignatureByte(SignatureByte Nr);
        void WriteFuse( FuseType Typ, uint8_t fuse );
        uint8_t ReadFuse( FuseType Typ );                
        
        void WriteProgramPage(uint16_t addr);
        void LoadProgramPage(uint16_t addr,uint8_t lowData,uint8_t highData);        
        uint8_t ReadProgramFlash(uint16_t addr, bool highByte);

    private:
    
        uint8_t ReadByte(FILE *file);    
        void StillProgramming();
        SPI  spiPort;
        DigitalOut resetPin;
        uint16_t mPageSize;
        
        PRGCB progressCB;        
};

#endif
