#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20);            // LCD: RS, E, D4-D7
SPI spi(p5, p6, p7);                                  // SPI: MOSI, MISO, SCLK (MISO not used with LCD)
DigitalOut lat(p8);                                   // data latch for LED driver TLC59281
DigitalOut Sel0(p26);                                 // input select bits:
DigitalOut Sel1(p25);                                 //  "
DigitalOut Sel2(p24);                                 //  "
DigitalIn In0(p14);                                   // input from switches, keypad etc
DigitalIn In1(p13);                                   //  "
DigitalIn In2(p12);                                   //  "
DigitalIn In3(p11);                                   //  "
I2C i2c(p9, p10);                                     // I2C: SDA, SCL pins
DigitalOut Trigger(p28);                              // Ultrasonic rangefinder trigger pin
DigitalIn  Echo(p27);                                 // Ultrasonic rangefinder echo pin
Timer Sonar;                                          // Ultrasonic timer
DigitalOut led1(LED1);                                
Serial out(USBTX, USBRX);                             
short LEDbits = 0;                                    // global led status used for readback

/*Functions used to initialize the Internet connection*/
/*LocalFileSystem fs("webfs");                         
EthernetNetIf eth;                                    
HTTPServer svr;                                       
Ticker WebUpdate;                                     // Interrupt timer to update web page                      //
                             
extern "C" void mbed_mac_address(char *mac);          

void WebServerPoll () {
    Net::poll();
    led1=!led1; //Show that we are alive
}

int InitWebServer() {
  EthernetErr ethErr = eth.setup();
  if(ethErr) {
    return -1;
  }

  FILE *fp = fopen("/webfs/index.htm", "w");          // Open "out.txt" on the local file system for writing
  fprintf(fp, "<html><head><title>Hello World online</title></head><body><h1>Hello World from Mbed NXP LPC1768!</h1></body></html>");
  fclose(fp);                                         // Close file
  FSHandler::mount("/webfs", "/files");               // Mount /webfs path on /files web path
  FSHandler::mount("/webfs", "/");                    // Mount /webfs path on web root path
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/");                     // Default handler
  svr.bind(80);                                       // Example : http://155.245.21.144
  WebUpdate.attach(&WebServerPoll, 0.1);              // update webserver every 100ms
  return 0;                                           // return without error
}

void HTTPText(char t[4000]) {
  FILE *fp = fopen("/webfs/index.htm", "w");          // Open "out.txt" on the local file system for writing
  fprintf(fp, t);
  fclose(fp);
}*/

/*Function used to initialize the board sensors and actuators*/
int ReadSonar() {
    Trigger = 1;                                      // set sonar trigger pulse high
    Sonar.reset();                                    // reset sonar timer
    wait_us(10.0);                                    // 10 us pulse
    Trigger = 0;                                      // set sonar trigger pulse low
    while (Echo == 0) {};                             // wait for echo high (8 cycles have been transmitted)
    Sonar.start();                                    // echo high so start timer
    while (Echo == 1) {};                             // wait for echo low
    Sonar.stop();                                     // echo low so stop timer
    return (Sonar.read_us()*10)/58;                   // read timer and scale to mm
}

void InitLEDs() {
    lat = 0;                                          // latch must start low
    spi.format(16,0);                                 // SPI 16 bit data, low state, high going clock
    spi.frequency(1000000);                           // 1MHz clock rate
}

void SetLEDs(short ledall) {
    LEDbits = ledall;                                 // update global led status
    spi.write((LEDbits & 0x03ff) | ((LEDbits & 0xa800) >> 1) | ((LEDbits & 0x5400) << 1));
    lat = 1;                                          // latch pulse start 
    lat = 0;                                          // latch pulse end
}

void SetLED(short LEDNo, short LEDState) {
    LEDNo = ((LEDNo - 1) & 0x0007) + 1;               // limit led number
    LEDState = LEDState & 0x0003;                     // limit led state
    LEDNo = (8 - LEDNo) * 2;                          // offset of led state in 'LEDbits'
    LEDState = LEDState << LEDNo;
    short statemask = ((0x0003 << LEDNo) ^ 0xffff);   // mask used to clear led state
    LEDbits = ((LEDbits & statemask) | LEDState);     // clear and set led state
    SetLEDs(LEDbits);
}

void SelInput(short Input) {
    Sel0 = Input & 0x0001;                            // set sel[0:2] pins
    Sel1 = (Input >> 1) & 0x0001;                     //
    Sel2 = (Input >> 2) & 0x0001;                     //
}

short ReadSwitches() {
    SelInput(5);                                      // select least significant 4 switches in[3:0]
    short Switches = In0 + (In1 << 1) + (In2 << 2) + (In3 << 3);
    SelInput(4);                                      // select most significant 4 switches in[3:0]
    return (Switches + (In0 << 4) + (In1 << 5) + (In2 << 6) + (In3 << 7));
}

short ReadSwitch(short SwitchNo) {
    SwitchNo = ((SwitchNo - 1) & 0x0007) + 1;         // limit switch number
    SwitchNo = 8 - SwitchNo;                          // offset of switch state in ReadSwitches()
    short SwitchState = ReadSwitches();               // read switch states
    SwitchState = SwitchState >> SwitchNo;            // shift selected switch state into ls bit
    return (SwitchState & 0x0001);                    // mask out and return switch state 
}

/*Set reference distance:
if the distance sensed by the sonar is the same for 9 seconds,
it will be the reference distance, otherwise restart the cycle*/
int setDistance() {
    int D_temp = ReadSonar();
    int D;
    
    lcd.cls();
    lcd.printf("setting distance");

    SetLEDs(0);

    for(int i=0; i<9; i++) {
        D = ReadSonar();

        /*Allow an extra range of 10 mm for setting the distance*/
        if(D_temp - 10 < D && D_temp + 10 > D) {
            D_temp = D; //reset D_temp
            i = 0; //restart setting the distance
            SetLEDs(0);
        }
        else {
            wait(1);
            SetLED(i%9, 1);
        }
    }

    lcd.cls();
    lcd.printf("distance set at\n%d", D);
    wait(2);

    return D;
}

int main() {
    InitLEDs();                                      
    //InitWebServer();                             
    int D = setDistance();
    int D1;
    int T_ON = 0; //Time (seconds) the escalator is ON
    int T_tot = 0; //Time (seconds) since the system started working
    int timeSaved; //Time saved (seconds)
    int energySaved = 0; //Percentage of energy saved
    char ON = 0;
    
    //char Buffer[4000];
  
    while(1) {        
        D1 = ReadSonar();
        
        /*ESCALATOR_POWER_ON*/
        if(D1 < D - 10) { //Allow an extra range of 10 mm when sensing the distance
            T_ON++;
            ON = 1;
        }

        /*ESCALATOR_POWER_OFF*/
        else
            ON = 0;
        
        T_tot++;
        energySaved = 100 - ((100*T_ON)/T_tot); //(previously the escalator was always ON)
        timeSaved = T_tot - T_ON;
        
        int firstOnSwitch = 0; //used to identify the switch
        
        for (int a= 1; a < 9; a++ ) {                     // map Switch states to led's
            SetLED (a,(ReadSwitch(a) + 1));           
            
            if(ReadSwitch(a) == 1) {
                firstOnSwitch = a; 
            }
        }
        
        /*Display the data collected on the LCD of the board*/
        switch(firstOnSwitch)
        {
            /*Switch 1: percentage of energy saved*/
            case 1:
                lcd.cls();
                lcd.printf("Energy Saved =\n%d%c", energySaved, '%');
                break;

            /*Switch 2: total elapsed time since the system started working*/
            case 2:
                lcd.cls();
                lcd.printf("T_tot:\n%d", T_tot);
                break;

            /*Switch 3: amount of time the escalator has been ON*/
            case 3:
                lcd.cls();
                lcd.printf("T_ON =\n%d", T_ON);
                break;

            /*Switch 4: amount of time saved (time the escalator has been OFF)*/
            case 4:
                lcd.cls();
                lcd.printf("Time saved =\n%d", timeSaved);
                break;

            /*No Switch: current state of the escalator (ON/OFF)*/
            default:
                if(ON == 1) {
                    lcd.cls();
                    lcd.printf("Escalator\nON");
                }
                else {
                    lcd.cls();
                    lcd.printf("Escalator\nOFF");
                }
        }
        
        /*HTML and CSS code to be sent to the dedicated Web Page (MAC Address)*/
        /*sprintf(Buffer, "<!DOCTYPE html><html><head><title>Escalator Smart Switch</title></head><body><style type=\"text/css\">.tg  {border-collapse:collapse;border-spacing:0;border-color:#aabcfe;margin:0px auto;}.tg td{font-family:Arial, sans-serif;font-size:14px;padding:10px 5px;border-style:solid;border-width:1px;overflow:hidden;word-break:normal;border-color:#aabcfe;color:#669;background-color:#e8edff;}.tg th{font-family:Arial, sans-serif;font-size:14px;font-weight:normal;padding:10px 5px;border-style:solid;border-width:1px;overflow:hidden;word-break:normal;border-color:#aabcfe;color:#039;background-color:#b9c9fe;}.tg .tg-wfog{font-weight:bold;font-size:22px;color:#f56b00;text-align:center;vertical-align:top}.tg .tg-3v14{background-color:#D2E4FC;font-weight:bold;font-size:18px;text-align:center;vertical-align:top}.tg .tg-5frq{font-style:italic;text-align:center;vertical-align:top}.tg .tg-xqmu{background-color:#D2E4FC;font-style:italic;text-align:center;vertical-align:top}</style>");
        sprintf(Buffer + strlen(Buffer), "<table class=\"tg\"><tr><th class=\"tg-wfog\" colspan=\"3\">Escalator MAC ADDRESS</th></tr><tr><td class=\"tg-3v14\">Value</td><td class=\"tg-3v14\">Currently</td><td class=\"tg-3v14\">Previously</td></tr>");
        sprintf(Buffer + strlen(Buffer), "<tr><td class=\"tg-5frq\">Working Time</td><td class=\"tg-5frq\">%d seconds</td><td class=\"tg-5frq\">%d seconds</td></tr>", T_ON, T_tot);
        sprintf(Buffer + strlen(Buffer), "<tr><td class=\"tg-xqmu\">Working Time Saved</td><td class=\"tg-xqmu\" colspan=\"2\">%d seconds</td></tr>", timeSaved);
        sprintf(Buffer + strlen(Buffer), "<tr><td class=\"tg-5frq\">Energy Saved</td><td class=\"tg-5frq\" colspan=\"2\">%f</td></tr></table></body></html>", energySaved);
        HTTPText(Buffer);*/                             // write to index.htm
        
        wait(1);        
    }
}
