#include "mbed.h"
#include "USBMouseKeyboard.h"

USBMouseKeyboard key_mouse;
Serial pc(USBTX, USBRX);

#define NFIELDS (6)
char* pFields[NFIELDS];

void ParseCommands(char* Buffer, char** pFields, uint32_t numFields, char* delimiter) {
    char* pString = Buffer;
    char* pField;

    for (uint32_t i=0; i<numFields; i++) {
        pField = strtok(pString, delimiter);
        if (pField != NULL) {
            pFields[i] = pField;
        } else {
            pFields[i] = "";
        }
        pString = NULL; //parse next
    }
    //Connection to device atempted
    if (strcmp("DRCmbed", pFields[0]) == 0) {
        pc.printf("mbeddevice\r\n");//Validate correct port query (For Ext Application Port Chcking)
    }
    ////////////////////////////////
    
    if (strcmp("Vector", pFields[0]) == 0) {
        key_mouse.move(atoi(pFields[1]),atoi(pFields[2]));
        pc.printf("Vector Issued\r\n");
    }

    if (strcmp("Click", pFields[0]) == 0) {
        if (strcmp("LPress", pFields[1]) == 0) {
            key_mouse.press(MOUSE_LEFT);
        }
        if (strcmp("LRelease", pFields[1]) == 0) {
            key_mouse.release(MOUSE_LEFT);
        }
        if (strcmp("LClick", pFields[1]) == 0) {
            key_mouse.click(MOUSE_LEFT);
        }
        if (strcmp("LDClick", pFields[1]) == 0) {
            key_mouse.doubleClick();
        }
        if (strcmp("RPress", pFields[1]) == 0) {
            key_mouse.press(MOUSE_RIGHT);
        }
        if (strcmp("RRelease", pFields[1]) == 0) {
            key_mouse.release(MOUSE_RIGHT);
        }
        if (strcmp("RClick", pFields[1]) == 0) {
            key_mouse.click(MOUSE_RIGHT);
        }
        pc.printf("Click Issued\r\n");
    }

    if (strcmp("Type", pFields[0]) == 0) {
        key_mouse.printf(pFields[1]);
        pc.printf("Type Issued\r\n");
    }
    
    if (strcmp("Keyboard", pFields[0]) == 0) {
        if (strcmp("Return", pFields[1]) == 0) {
            key_mouse.printf("\n");
        }
        if (strcmp("Backspace", pFields[1]) == 0) {
            key_mouse.printf("\b");
        }
        if (strcmp("Tab", pFields[1]) == 0) {
            key_mouse.printf("\t");
        }
        if (strcmp("Capslock", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_CAPS_LOCK);
        }
        if (strcmp("FKey1", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F1);
        }
        if (strcmp("FKey2", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F2);
        }
        if (strcmp("FKey3", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F3);
        }
        if (strcmp("FKey4", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F4);
        }
        if (strcmp("FKey5", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F5);
        }
        if (strcmp("FKey6", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F6);
        }
        if (strcmp("FKey7", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F7);
        }
        if (strcmp("FKey8", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F8);
        }
        if (strcmp("FKey9", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F9);
        }
        if (strcmp("FKey10", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F10);
        }
        if (strcmp("FKey11", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F11);
        }
        if (strcmp("FKey12", pFields[1]) == 0) {
            key_mouse.keyCode(KEY_F12);
        }
        pc.printf("Keyboard Issued\r\n");
    }
    
    if (strcmp("Volume", pFields[0]) == 0) {
        if (strcmp("Up", pFields[1]) == 0) {
            key_mouse.mediaControl(KEY_VOLUME_UP);
        }
        if (strcmp("Down", pFields[1]) == 0) {
            key_mouse.mediaControl(KEY_VOLUME_DOWN);
        }
        pc.printf("Volume Issued\r\n");
    }
    
    if (strcmp("Scroll", pFields[0]) == 0) {
        key_mouse.scroll(atoi(pFields[1]));
        pc.printf("Scroll Issued\r\n");
    }
}

int main(int argc, char* argv[]) {
    pc.baud(9600);
    char buf[256];

//List of avalable commands
//DRCmbed <-- Sends an auto response back to the computer host computer (Ext app com port validation event)
//Type,Hello World <--Needs fix for spaces but can handle text the length how big the buffer is -1 = 255 bufferable characters
//Vector,1000,6000 <--Vectors can be anything you specify
//Click,LPress <--Holds the left mouse click down
//Click,LClick <--Clicks the left mouse button
//Click,LDClick <--Makes a left double click
//Click,LRelease <--Releases the left mouse button
//Click,RPress <--Holds the right mouse click down
//Click,RRelease <--Releases the left mouse button
//Click,RClick <--Clicks the right mouse button
//Click,RDClick <--Makes a right double click
//Scroll,10 <--Value can be anything you specify
//Scroll,-10 <--Value can be anything you specify
//Volume,Up <--Turns the system volume up 1 notch
//Volume,Down <--Turns the sstem volume down 1 notch
//Keyboard,Tab <--Emulates the system tab key
//Keyboard,Capslock <--Emulates the system capslock key
//Keyboard,Backspace <--Emulates the system backspace key
//Keyboard,Return <--Emulates the system enter key
//Keyboard,FKey1 <--Emulates the system F keys
//Keyboard,FKey2
//Keyboard,FKey3
//Keyboard,FKey4
//Keyboard,FKey5
//Keyboard,FKey6
//Keyboard,FKey7
//Keyboard,FKey8
//Keyboard,FKey9
//Keyboard,FKey10
//Keyboard,FKey11
//Keyboard,FKey12
    while (1) {
        pc.scanf("%s", buf);
        ParseCommands(buf, pFields, NFIELDS, ",");
    }
}