#include "mbed.h"
#include <ros.h>
#include <std_msgs/Int16.h>
#include <std_msgs/Bool.h>
DigitalIn leakSensor(PC_2);
DigitalOut myled(LED1);
 
ros::NodeHandle nh; 
std_msgs::Bool leak_msg;
ros::Publisher leak_publisher("leak", &leak_msg);
 
int main() 
{
    nh.initNode();
    nh.advertise(leak_publisher);
    
    while (1)
    {
        if(leakSensor) 
        {
            leak_msg.data = 1;
        }
        else
        {
            leak_msg.data = 0;
        }
        leak_publisher.publish(&leak_msg);
        nh.spinOnce();
        wait_ms(200);
    }
}
