#ifndef _BUZZER_H_
#define _BUZZER_H_

#include "mbed.h"

class Buzzer {
public:
  //all songs / sounds / routines names
    enum Song{
      POST_SOUND=0,
      IMPERIAL_MARCH,
      CUSTOM_SONG};
  //constructor
    Buzzer (PinName pin);
  //generates a sound of a desired frequency, for a fixed amount of time in s
  //no wait used (the main code execution is not delayed)
    void beep(float frequency, float time);
  //same functionality like beep, but it delays the execution
    void delayBeep(float frequency, float time);
  //given a Song defined in the enum above and a number of iterations
  //it sings the song for the specified amount of time
    void sing(Song, unsigned short);
  //it sings the song only once
    void sing(Song);
  //stops the buzzer
    void stop();
private :
    PwmOut pwm;
    Timeout timeOff;
};


#endif

