/*
Mbed class for Buzzer
*/
#include "Buzzer.h"
#include "mbed.h"
#include "Tones.h"

Buzzer::Buzzer(PinName inPin) : pwm(inPin) {
    pwm.write(0.0);
}

void Buzzer::stop() {
    pwm.write(0.0);
}

void Buzzer::beep(float freq, float time) {
    pwm.period(1.0/freq);
    pwm.write(0.5);            // 50% duty cycle - beep on
    timeOff.attach(this,&Buzzer::stop, time);   // time to off
}

void Buzzer::delayBeep(float freq, float time) {
    pwm.period(1.0/freq);
    pwm.write(0.5);
    wait(time);
    stop();
}

void Buzzer::sing(Song song){
    switch (song){
        case POST_SOUND:
            beep(C6,0.2);
        break;
        case IMPERIAL_MARCH: // just random stuff at the moment
            delayBeep(G4, 0.5);
            delayBeep(P, 1);
            delayBeep(G5, 0.5);
            delayBeep(P, 1);
            delayBeep(G6, 0.5);
        break;
    }
}
void Buzzer::sing(Song song, unsigned short iterations){
    for (int i = 0; i < iterations; i++){
        sing(song);
    }
}

