/*
 * HBridge.cpp
 *
 *  Created on: Jun 4, 2016
 *      Author: Developer
 */

#include <HBridge.hpp>
#include <cmath>

HBridge::HBridge(PinName PWMPin, PinName DirectionPin)
: PWMOut(PWMPin), DirectionOut(DirectionPin) {
    // 10 ms period == 100 Hz works well.
    PWMOut.period_us(250);
}

HBridge::~HBridge() {
    // TODO Auto-generated destructor stub
}

void HBridge::write(float percent) {
    // Write the percent value as a PWM out.
    PWMOut.write(std::abs(percent));
    // Write the direction as the sign of percent.
    DirectionOut.write(percent >= 0);
    // Set the output has changed flag to 1.
    outputHasChanged = true;
}

float HBridge::read() {
    static float prevValue;
    if (outputHasChanged) {
        outputHasChanged = false;
        prevValue = (DirectionOut.read()) ? PWMOut.read() : -PWMOut.read();
    }
    return prevValue;
}
