/**
 * @file QuadEnc.cpp
 * @date June 2nd, 2016
 * @author Weimen Li
 */

#include "QuadEnc.hpp"

QuadEnc::QuadEnc(PinName ChannelA, PinName ChannelB, float CPR) :
count(0), bHasNewCount(false),
CPR(CPR), ChannelAIn(ChannelA), ChannelBIn(ChannelB), ChannelAInter(ChannelA), ChannelBInter(ChannelB),
prevCount(0), prevRevs(0), enc_val(0) {
    
    // Configure Channel A interrupt to trigger on rise and fall.
    ChannelAInter.rise(this, &QuadEnc::QuadEncISR);
    ChannelAInter.fall(this, &QuadEnc::QuadEncISR);

    // Configure Channel B interrupt to trigger on rise and fall.
    ChannelBInter.rise(this, &QuadEnc::QuadEncISR);
    ChannelBInter.fall(this, &QuadEnc::QuadEncISR);

}

QuadEnc::~QuadEnc() {

}

void QuadEnc::QuadEncISR() {
    uint8_t QuadEncData = (ChannelAIn.read() << 1) | ChannelBIn.read();
    const int8_t QuadEncLUT[16] = { 0, -1, 1, 0, 1, 0, 0, -1, -1, 0, 0, 1, 0, 1,
            -1, 0 };
    enc_val = enc_val << 2;
    enc_val = enc_val | QuadEncData;
    count += QuadEncLUT[enc_val & 0b1111];
    bHasNewCount = true;
}

bool QuadEnc::hasNewCount() {
    bool returnVal = bHasNewCount;
    bHasNewCount = false;
    return returnVal;
}

float QuadEnc::getRevs() {
    // Capture the current count to avoid corruption.
    float currentCount = count;
    if (prevCount != currentCount) {
        prevRevs = currentCount / CPR;
    }
    return prevRevs;
}

void QuadEnc::reset() {
    count = 0;
    bHasNewCount = false;
}
