/**
 * @file FixedRefresh.hpp
 * @author Weimen Li
 * @date June 26th, 2016
 * @class FixedRefresh
 * @brief This class is used in an RTOS to ensure that iterations of a loop happen at fixed time intervals,
 * regardless of how long other code in the loop takes. In doing so, it waits the thread that is currently
 * running to allow other threads to run.
 */

/*
 * FixedRefresh.hpp
 *
 *  Created on: Jun 26, 2016
 *      Author: Developer
 */

#ifndef FIXEDREFRESH_HPP_
#define FIXEDREFRESH_HPP_
#include "mbed.h"
#include "rtos.h"

class FixedRefresh {
public:
    /// Constructor for the FixedRefresh class.
    FixedRefresh();
    /// Destructor for the FixedRefresh class.
    virtual ~FixedRefresh();

    /*
     * @brief Function which ensures as much as possible that micros microseconds elapses
     * between successive calls, no matter how long the computation beforehand took.
     * @args micros The number of microseconds that should elapse between successive calls.
     * @returns false if waiting will not occur because greater than micros microseconds has
     * elapsed since the previous calls. If the function does return false, then your computation
     * is taking too much time.
     */
    bool refresh_us(uint32_t micros);
private:
    /// The number of microseconds to wait.
    uint32_t wait_us;
    Timer elapsedTime;
    Timeout waitTimer;
    /**
     * @brief Mutex that is locked
     */
    Semaphore waitSemaphore;
    void timerCallback();
};

#endif /* FIXEDREFRESH_HPP_ */
