#include "mbed.h"

I2C i2c(I2C_SDA, I2C_SCL);
Serial pc(SERIAL_TX, SERIAL_RX);

int main()
{
    pc.baud(115200);
    pc.printf("I2C scanner starting\n");

    i2c.frequency(100e3); // default freq (100kHz)

    const char *data = "1";

    int ack;
    unsigned char address;
    for (address = 1; address < 127; address++) {
        ack = i2c.write(address << 1, data, 1); // address is shifted to the left, because mbed uses 8bits
        if (ack == 0) {
            pc.printf("Sent 0x%X; 0x%X ACK \r\n", address << 1, address); // Send command string
        }
        wait_ms(2);
    }

    pc.printf("I2C scanner done\n");
}