#ifndef LED_INTERFACE_H
#define LED_INTERFACE_H

#include "mbed.h"

#define RED      0
#define GREEN    1
#define BLUE     2
#define NUM_LEDS 3
class SMART_LED {
    public:
        SMART_LED(PinName redPin, PinName greenPin, PinName bluePin);
        void off();
        void set(uint8_t r, uint8_t g, uint8_t b);
               
    private:
        PwmOut _redLedPwm, _greenLedPwm, _blueLedPwm;
        PwmOut *_pwmLed[NUM_LEDS];
        Ticker _updateLedTick;
        float _current[NUM_LEDS];
        float _goal[NUM_LEDS];

        uint8_t _normalFadeSpeed;
        void ledUpdateTimerTick();
        void fadeToRgb(uint8_t r, uint8_t g, uint8_t b);

};


#endif /* LED_INTERFACE_H */