// Smart LED handling

#include "led.h"

SMART_LED::SMART_LED(PinName redPin, PinName greenPin, PinName bluePin):
    _redLedPwm(redPin), _greenLedPwm(greenPin), _blueLedPwm(bluePin) 
{
    _pwmLed[RED]   =  &_redLedPwm;
    _pwmLed[GREEN] =  &_greenLedPwm;
    _pwmLed[BLUE]  =  &_blueLedPwm;
    for (int i = 0; i < NUM_LEDS; i++) {
        *_pwmLed[i] = 0;
        _pwmLed[i]->period(0.001f);
        _current[i] = 0;
        _goal[i] = 0;
    }
    off();
}
void SMART_LED::ledUpdateTimerTick() {
    for (int i = 0; i < NUM_LEDS; i++) {
        if (_current[i] != _goal[i]) {
            float newSetting = _goal[i];
            if (newSetting < 0.0) { newSetting = 0.0;} 
            if (newSetting > 1.0) { newSetting = 1.0;}

            *_pwmLed[i] = newSetting;
            _current[i] = newSetting;
        }
    }
}
void SMART_LED::fadeToRgb(uint8_t r, uint8_t g, uint8_t b)
{
    // not all LED colors are the same power, 
    // these empircially determined changes helps get them to be about the same
    _goal[RED] = (200-r) / 150.0;
    _goal[GREEN] = (255-g) / 225.0;
    _goal[BLUE] = (300-b) / 255.0;
    ledUpdateTimerTick();
}

void SMART_LED::off() 
{
    fadeToRgb(0,0,0);
}

void SMART_LED::set(uint8_t r, uint8_t g, uint8_t b)
{
    fadeToRgb(r, g, b);
}
