#include "button.h"
#include "mbed.h"

#define HIGH 1
#define LOW  0


void initializeButtonDebounce()
{
    // possibly start ticker if you want to auto debounce
}

// button press with hysterisis
bool debounceButtonPress(int reading)
{
  
  static int buttonState = HIGH;       // the current reading from the input pin
  static int lastButtonState = HIGH;   // the previous reading from the input pin
  static long lastDebounceTime = 0;  // the last time the output pin was toggled
  const long kDebounceDelay = 3;    // the debounce time; increase if the output flickers
  
  lastDebounceTime++;
  if (reading != lastButtonState) {
    // reset the debouncing timer
    lastDebounceTime = 0;
    lastButtonState = reading;
  } 
  if (lastDebounceTime >= kDebounceDelay) {
    // whatever the reading is at, it's been there for longer
    // than the debounce delay, so take it as the actual current state:

    // if the button state has changed:
    if (reading != buttonState) {
      buttonState = reading;

      // only indicate button pressed if low, input pulled up and button connects to low
      if (buttonState == LOW) {
        return true;
      }
    }
  }
  return false;
}
