#include "mbed.h"

DigitalOut led1(LED1);

Thread t1;
Thread t2;

Serial pc(USBTX, USBRX, 9600);

int ton = 500;
int toff = 500;
char tmp;
int plusminus;

Mutex mutex;

void led_blink()
{
    while(1){
        led1 = 1;
        ThisThread::sleep_for(ton);
        led1 = 0;
        ThisThread::sleep_for(toff);
    }
}

void interface()
{
    while(1){
        if(pc.readable())
        {
            tmp = pc.getc();
            
            if(tmp == 'H')
            {
                printf("High wird geaendert\n");
                
                while(plusminus != 'L' && plusminus != 'R')
                {
                    plusminus = pc.getc();
                    
                    if(plusminus == '+')
                    {
                        mutex.lock();
                        ton += 100;
                        
                        if(ton >= 2000)
                        {
                            printf("Maximalwert erreicht\n");
                            ton = 2000;
                        }
                        
                        mutex.unlock();
                        printf("Ton = %d\n", ton);
                    }
                    
                    if(plusminus == '-')
                    {
                        mutex.lock();
                        ton -= 100;
                        
                        if(ton <= 100)
                        {
                            printf("Minimalwert erreicht\n");
                            ton = 100;
                        }
                        
                        mutex.unlock();
                        printf("Ton = %d\n", ton);
                    }
                }
            } 
            
            if(tmp == 'L')
            {
                printf("Low wird geaendert\n");
                
                while(plusminus != 'H' && plusminus != 'R')
                {
                    plusminus = pc.getc();
                    
                    if(plusminus == '-')
                    {
                        mutex.lock();
                        toff -= 100;
                        
                        if(toff <= 100)
                        {
                            printf("Minimalwert erreicht\n");
                            toff = 100;
                        }
                        
                        mutex.unlock();
                        printf("Toff = %d\n", toff);
                    }
                    
                    if(plusminus == '+')
                    {
                        mutex.lock();
                        toff += 100;
                        
                        if(toff >= 2000)
                        {
                            printf("Maximalwert erreicht\n");
                            toff = 2000;
                        }
                        
                        mutex.unlock();
                        printf("Toff = %d\n", toff);
                    }
                }
                
            } 
            
            if(tmp == 'R')
            {
                printf("Reset\n");
                
                mutex.lock();
                ton = 500;
                toff = 500;
                
            } 
        }
    }
}

int main() {    
        t1.start(led_blink);
        t2.start(interface);
    
    while(1) {
    }
}
