#include "mbed.h"
#include "Servo.h"
#include "TextLCD.h"
#include "DebouncedIn.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7
DebouncedIn setbutton(p5);
DebouncedIn gobutton(p6);
Servo myservo(p21);
DigitalOut leda(LED1);
DigitalOut ledb(LED2);
DigitalOut ledc(LED3);
DigitalOut ledd(LED4);
Timer t;
Timer t2;

int set();
int dip();
int set (int currentstate);
int displaystate(int currentstate);
int maketea(int currentstate);
int dipping();
int alert();
int alertoff();

int main() {
    int state;
    state = 1;
    myservo = 1;
    lcd.cls();
    lcd.printf("Start?\n");
    while(1) {
       if (setbutton.rising()) {
            state = set(state);
        }
        else if (gobutton.rising()) {
            maketea(state);
        }       
    }
}

int set(int currentstate) { //For setting which mode to use
    t.start(); //Inactivity timer
    lcd.cls();
    displaystate(currentstate);
    while (gobutton != 1 and t < 10) {
        if (setbutton.rising()) {
            currentstate = currentstate + 1; //Advances state
            if (currentstate > 9) { //Loops back to start
                currentstate = 1;
            }
            lcd.cls();
            displaystate(currentstate); //Update current state
            wait(0.25); //Debounce
            t.reset();
            t.start(); //Reset inactivity timer
        }
    }
    lcd.cls();
    lcd.printf("Start?\n"); //Reset screen
    return currentstate;
}

int displaystate(int currentstate) { //Displays current setting
    if (currentstate == 1) {
        lcd.printf("1 min - dip\n");
    }
    else if (currentstate == 2) {
        lcd.printf("2 mins - dip\n");
    }
    else if (currentstate == 3) {
        lcd.printf("3 mins - dip\n");
    }
    else if (currentstate == 4) {
        lcd.printf("1 min - no dip\n");
    }
    else if (currentstate == 5) {
        lcd.printf("2 mins - no dip\n");
    }
    else if (currentstate == 6) {
        lcd.printf("3 mins - no dip\n");
    }
    else if (currentstate == 7) {
        lcd.printf("4 mins - no dip\n");
    }
    else if (currentstate == 8) {
        lcd.printf("5 mins - no dip\n");
    }
    else if (currentstate == 9) {
        lcd.printf("QTEST\n");
    }
    return 0;
}

int maketea(int currentstate) { //Main teamaking routine
    lcd.cls();
    lcd.printf("Brewing...\n");
    displaystate(currentstate); //Display status
    int time;
    int dip;
    if (currentstate == 1) { //Initialise time and dipping status
        time = 60;
        dip = 1;
    }
    else if (currentstate == 2) {
        time = 120;
        dip = 1;
    }
    else if (currentstate == 3) {
        time = 180;
        dip = 1;
    }
    else if (currentstate == 4) {
        time = 60;
        dip = 0;
    }
    else if (currentstate == 5) {
        time = 120;
        dip = 0;
    }
    else if (currentstate == 6) {
        time = 180;
        dip = 0;
    }
    else if (currentstate == 7) {
        time = 240;
        dip = 0;
    }
    else if (currentstate == 8) {
        time = 300;
        dip = 0;
    }
    else if (currentstate == 9) {
        time = 10;
        dip = 0;
    }
    myservo = 0; //Dunk teabag
    t.start(); //Start tea timer
    while (t < time) { //While there's still time left
        if (dip == 1) { //If dipping, dip teabag
            wait(1);
            dipping();
        }
        if (gobutton.rising()) { //If cancelling
            lcd.cls();
            lcd.printf("Press again to\n");
            lcd.printf("stop brewing.\n");
            t2.start(); //Start (secondary) inactivity timer
            while (t2 <= 5) {
                if (gobutton.rising()) {
                    time = 0; //Resets time to run to 0, thus pulling out of main while loop
                    break; //Pulls out of this loop
                }
            }
            t2.reset();
            lcd.cls();
            lcd.printf("Brewing...\n");
            displaystate(currentstate); //Reset screen to brewing
        }            
    }
    t.reset();
    myservo = 1;
    lcd.cls();
    lcd.printf("Done!\n");
    lcd.printf("Reset?\n");
    t.start();
    while ((!setbutton.rising()) && (!gobutton.rising())) { //If not reset in 90 seconds, alert
        if (t > 90) {
            alert();
        }
    }
    alertoff();
    lcd.cls();
    lcd.printf("Start?\n"); //Reset
    wait(1);
    return 0;
}

int dipping() { //Dipping routine
    myservo = 0.5;
    wait(1);
    myservo = 0;
    return 0;
}    

int alert() { //Alert using on-board LEDs
    int y;
    for ( y = 0; y != 1; y++ ) {
        leda = 1;
        ledb = 0;
        ledc = 1;
        ledd = 0;
        wait(0.2);
        leda = 0;
        ledb = 1;
        ledc = 0;
        ledd = 1;
        wait(0.2);
    }
    return 0;
}

int alertoff() { //Resets on-board LEDs to 0
    leda = 0;
    ledb = 0;
    ledc = 0;
    ledd = 0;
    return 0;
} 