#include "mbed.h"
#include "Servo.h"
#include "TextLCD.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7
DigitalIn setbutton(p5);
DigitalIn gobutton(p6);
Servo myservo(p21);
Timer t;

int set();
int dip();
int set (int currentstate);
int displaystate(int currentstate);
int maketea(int currentstate);
int dipping();

int main() {
    int state;
    state = 1;
    myservo = 1;
    lcd.cls();
    lcd.printf("Start?\n");
    while(1) {
       if (setbutton == 1) {
            state = set(state);
        }
        else if (gobutton == 1) {
            maketea(state);
        }       
    }
}

int set(int currentstate) {
t.start();
    while (gobutton != 1 and t < 10) {
        if (setbutton == 1) {
            currentstate = currentstate + 1;
            if (currentstate > 6) {
                currentstate = 1;
            }
            lcd.cls();
            displaystate(currentstate);
            wait(0.25);
            t.reset();
            t.start();
        }
    }
    lcd.cls();
    lcd.printf("Start?\n");
    return currentstate;
}

int displaystate(int currentstate) {
    if (currentstate == 1) {
        lcd.printf("1 min - dip\n");
    }
    else if (currentstate == 2) {
        lcd.printf("2 mins - dip\n");
    }
    else if (currentstate == 3) {
        lcd.printf("3 mins - dip\n");
    }
    else if (currentstate == 4) {
        lcd.printf("1 min - no dip\n");
    }
    else if (currentstate == 5) {
        lcd.printf("2 mins - no dip\n");
    }
    else if (currentstate == 6) {
        lcd.printf("3 mins - no dip\n");
    }
    return 0;
}

int maketea(int currentstate) {
    lcd.cls();
    lcd.printf("Brewing...\n");
    displaystate(currentstate);
    int time;
    int dip;
    if (currentstate == 1) {
        time = 60;
        dip = 1;
    }
    else if (currentstate == 2) {
        time = 120;
        dip = 1;
    }
    else if (currentstate == 3) {
        time = 180;
        dip = 1;
    }
    else if (currentstate == 4) {
        time = 60;
        dip = 0;
    }
    else if (currentstate == 5) {
        time = 120;
        dip = 0;
    }
    else if (currentstate == 6) {
        time = 180;
        dip = 0;
    }
    myservo = 0;
    t.start();
    while (t < time) {
        if (dip == 1) {
            dipping();
        }
    }
    t.reset();
    myservo = 1;
    lcd.cls();
    lcd.printf("Done!\n");
    wait(5);
    lcd.cls();
    lcd.printf("Start?\n");
    return 0;
}

int dipping() {
    myservo = 0.5;
    wait(1);
    myservo = 0;
    wait(1);
    return 0;
}    