#include "mbed.h"
#include "TextLCD.h"
#include "DebouncedIn.h"

BusOut led(LED4, LED3, LED2, LED1);
unsigned char i;
TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7
DebouncedIn setbutton(p5);

int main() {
    int state;
    state = 0;
    i = 0;
    while(1) {
        if (setbutton.rising()) {
            state = !state;
        }
        if (state == 0) {
            lcd.printf("Binary: %u\n", i);
            led = i;
        }
        else if (state == 1) {
            lcd.printf("Graycode: %u\n", i);
            led = i^(i>>1);
        }
        wait(1);
        i = i+1;
        if (i == 16) {
            i = 0;
        }
        lcd.cls();    
    }
}