//project: Real_time embedded system
#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"
#include "MMA7660.h"

// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);

//Temperature measurement sensor set up
LM75B tem(D14,D15);

//joystick
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn center(D4);

//two Potentiometers
AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

//3 Axis Accelerometer
MMA7660 MMA(D14,D15);

//led on shiled
PwmOut r (D5);
PwmOut b (D8);
PwmOut g (D9);

//temperature value store in x1,2,3,4
float a=0; //temperature store in a
float x1=0,x2=0,x3=0,x4=0;

//y axis point of each point need to plot on lcd
int y1=20,y2=20,y3=20,y4=20;

void counter (void);
void findy (void);
float d=0;//distance between each y-axis point on plot
float dyarray[18];
float x1array[18],x2array[18],x3array[18],x4array[18];
float x1min=0,x2min=0,x3min=0,x4min=0;

//find max and min for y axis
void findmax(void);
void findmin(void);
float xarray[]= {x1,x2,x3,x4};
float max=0;//max number of x1,2,3,4
float min=0;//min number of x1,2,3,4
//plot funciton
void plot(void);

//menu
int menu =0;//this integer to wtich menu
void joystick (void);//use joystick to change menu

//Highest tem and lowest tem
void temdata(void);
int nod=0;//number of data
int highlow=0;
float hightem=0,lowtem=0;

//timer
Timer t;
int main()
{
    r=1;
    b=1;
    g=1;
    lcd.cls();//clear screen
    t.start();//start timer
    while(1) {
        joystick();//detect any movement at joystick
        temdata();//collecting temperature data
        switch (menu) {//using swtich menu to show different case on screen
            case 0://title 1
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Real Time Embeded System");
                lcd.locate(0,18);
                lcd.printf("Scroll with Joystick");
                wait(1);
                break;
            case 1://title 2
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Project: Temprature Plot");
                lcd.locate(0,18);
                lcd.printf("Student No.170411");
                wait(1);
                break;
            case 2:// showing temperature and plot for latest four result
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Tem:");
                //print temperature
                lcd.locate(21,0);
                lcd.printf("%.1f\n",x1);

                lcd.locate(46,0);
                lcd.printf("%.1f\n",x2);

                lcd.locate(71,0);
                lcd.printf("%.1f\n",x3);

                lcd.locate(96,0);
                lcd.printf("%.1f\n",x4);
                plot();//plot diagram
                counter();//shift data from right to left and store latest data at x4
                wait(1);
                break;
            case 3://show how much time taken and how many data collect from temperature sensor
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Time taken: %.2f s",t.read());
                lcd.locate(0,17);
                lcd.printf("Number of data collect: %i",nod);
                wait(1);
                break;
            case 4:// show highest temperature
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Hightest temprature so far: ");
                lcd.locate(0,18);
                lcd.printf("Tem: %.2f",hightem);
                wait(1);
                break;
            case 5:// show lowest temperature
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Lowest temprature so far: ");
                lcd.locate(0,18);
                lcd.printf("Tem: %.2f",lowtem);
                wait(1);
                break;
        }//switch
    }//while
}//main
void joystick()//detect two button at joystick (up and down)
{
    //change "menu" to change menu at switch
    if (down==1) {
        menu=menu+1;
    }
    if (up==1) {
        menu=menu-1;
    }
    //use those if statement to create a close loop between menu=0 to menu=5
    if (menu>5) {
        menu=0;
    }
    if (menu<0) {
        menu=5;
    }

}
void temdata()
{
    a=tem.temp();//get current temperature and store to a
    nod=nod+1;//counter (nod) count how many data collect from sensor
    if (highlow==0) {//when collect first data, store first temperature value to hightem and lowtem
        hightem=a;
        lowtem=a;
        highlow=1;//set highlow to 1, so this function will only run once
    }
    if (hightem<=a) {//store highest temprature value into hightem
        hightem=a;
    }
    if (lowtem>=a) {//store lowest temprature value into lowtem
        lowtem=a;
    }
}
void counter()//shift data from right to left
{
    x1=x2;
    x2=x3;
    x3=x4;
    x4=a;
}
void plot()
{
    //plot diagram
    findy();//find y value at y axis of each data (x1,2,3,4)
    lcd.line(100,y4,76,y3,1);
    lcd.line(76,y3,50,y2,1);
    lcd.line(50,y2,27,y1,1);
}
void findy()
{
    findmax();//find maximum value from x1,2,3,4
    findmin();//find minimum value from x1,2,3,4
    d=(max-min)/18;//caculate different between each point at y-axis
    //y-axis point writen in yarray
    int yarray[] = {30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12};
    int i;
    for (i=0; i<18; i=i+1) {//using for loop to find y value for each x
        dyarray[i]=min+i*d;//this array store temperature map according to four x temperature and 18 y axis
        //x1
        x1array[i]=x1-dyarray[i];//find different between x1 and dyarray
        if (x1array[i]<0) {//store absolute vaue of x1array 
            x1array[i]=-x1array[i];
        }
        if (i==0) {//store first x1array to x1min
            x1min=x1array[i];
        }
        if (x1array[i]<=x1min) {//find minimum value of x1array, 
            y1=yarray[i];//store corresponding y into y1
            x1min=x1array[i];
        }
        //x2
        x2array[i]=x2-dyarray[i];
        if (x2array[i]<0) {
            x2array[i]=-x2array[i];
        }
        if (i==0) {
            x2min=x2array[i];
        }
        if (x2array[i]<=x2min) {
            y2=yarray[i];
            x2min=x2array[i];
        }
        //x3
        x3array[i]=x3-dyarray[i];
        if (x3array[i]<0) {
            x3array[i]=-x3array[i];
        }
        if (i==0) {
            x3min=x3array[i];
        }
        if (x3array[i]<=x3min) {
            y3=yarray[i];
            x3min=x3array[i];
        }
        //x4
        x4array[i]=x4-dyarray[i];
        if (x4array[i]<0) {
            x4array[i]=-x4array[i];
        }
        if (i==0) {
            x4min=x4array[i];
        }
        if (x4array[i]<=x4min) {
            y4=yarray[i];
            x4min=x4array[i];
        }
    }
}

void findmax()
{
    max=x1;
    int i;
    float xarray[]= {x1,x2,x3,x4};
    for(i=0; i<4; i=i+1) {
        if (xarray[i]>max) {
            max=xarray[i];
        }
    }
}

void findmin()
{
    min=x1;
    int i;
    float xarray[]= {x1,x2,x3,x4};
    for(i=0; i<4; i=i+1) {
        if (xarray[i]<min) {
            min=xarray[i];
        }
    }
}