/*
 Library wave file player by Tom Coxon

 Based on WAVEplayer by Vlad Cazan/Stephan Rochon modified by Tom Coxon to:

 1. Run correctly on the Embedded Artists LPCXpresso baseboard.
 2. To play 8 bit sample size in addition to original 16 bit
 3. To be more fault tolerant when playing wav files.
*/

#ifndef WAVPLAYER_H
#define WAVPLAYER_H

#include "mbed.h"

#define SAMPLE_FREQ 40000
#define BUF_SIZE (SAMPLE_FREQ/10)
#define SLICE_BUF_SIZE 1

typedef struct uFMT_STRUCT {
    short comp_code;
    short num_channels;
    unsigned sample_rate;
    unsigned avg_Bps;
    short block_align;
    short sig_bps;
} FMT_STRUCT;

class WavPlayer {

public:

    void play_wave(char *wavname);

private:

    void cleanup(char *);
    void fill_adc_buf(short *, unsigned);
    void swapword(unsigned *);

// a FIFO for the DAC
    short DAC_fifo[256];
    short DAC_wptr;
    short DAC_rptr;
    short DAC_on;

    void dac_out();

};

#endif
