#include "mbed.h"
 
PwmOut led(LED1);  // Led on board
PwmOut green(p25); // A green led is connected at Pin25 with resistor to ground

AnalogIn ain(p20); // Potmeter 810k connected between VOUT(3.3V Pin40) and GND (Pin1) with the wiper connect to Pin20 
 
int main() {
    green.period_us(100); // Set the period to 100uS = 10kHz
    led.period_ms(10);    // Set the period to 10mS = 100Hz
                          // Both periods will be set on 10mS, because the same timer is used for both
                          // Changing the period for one wil change the period for the others also
    while(1) { 
             led = ain;     // Set duty cycle for LED1
             green = ain/2; // Set duty cycle for the green led, the "on" time will only the half of the period
        }
    }