/*******************************************************************************************
* Program to test OptrexLCD library witch is a clone of TextLCD only with a different timing.
* Normaly it takes a 40us enable puls to execute an instruction, but with the optrex 20x4 LCD
* it takes 75us. Also the cls command takes 3ms instead of the 1.64ms which is normal.
* Because the timing is the only difference, all functionality is equal to TextLCD. 
* Probally the OptrexLCD library works with other LCD as well, if not the origenal TextLCD library
* can included instead.
* The program write the text: "Start" and after half a second: "Hello rownr:0" next to it on the first row.
* After another half a second it writes: "Second row? rownr:1" on the next row, then it
* will write: "Third row? rownr:2" on the next and: "Fourth row? rownr:3" on the last.
* After 1 second the screen got cleared and ASCII character nr.65 ("A") is put to the LCD at column "0"
* and row "0". Then character nr.66 ("B") is written to column "1" and row "1". Next nr67 ("C") is written
* to column "2", row "2" and nr68 ("D") on "3,3". Row "3" is the last row. When trying to select row "4" the 
* LCD goes in "Two Rows" mode instead of "Four Rows" mode. The characters "E" to "H" are written 
* in upwards direction.
**********************************************************************************************/
#include "mbed.h"
#include "OptrexLCD.h"

DigitalOut BlinkLed(LED4);  // when the led is blinking the program runs well

TextLCD lcd(p10, p12, p15, p16, p17, p18, TextLCD::LCD20x4 ); // rs, e, d0-d3
 
int main() 
{
    while(1)
    {        
        BlinkLed = !BlinkLed;       //indicates the programm is running
        
        lcd.printf("Start ");                   // the printf instruction writes a text string to the LCD
        wait(0.5);
        lcd.printf("Hello rownr:0\n");          // the "\n" directive tells the program to go to the next row.
        wait(0.5);
        lcd.printf("Second row? rownr:1\n");
        wait(0.5);
        lcd.printf("Third row?  rownr:2\n");
        wait(0.5);
        lcd.printf("Fourth row? rownr:3\n");    
        wait(0.5);
        lcd.printf("Fifth row?  rownr:4\n"); // there are only four rows, the fifth wil be at the first row, rownr:0.
        wait(0.5);
        lcd.printf("Sixth row?  rownr:5\n"); // this wil be written on the second row
        wait(2);
                
        lcd.cls();          // clear the LCD and go to column "0" and row "0"
        wait(0.5);
        
        lcd.putc(65);       // put character 65 (A) at column "0" and row "0"
        wait(0.5);
        lcd.locate(1,1);    // go to column "1" and row "1"
        lcd.putc(66);       // put a "B" in (1,1)
        wait(0.5);
        lcd.locate(2,2);        
        lcd.putc(67);       // put a "C" in (2,2)
        wait(0.5);
        lcd.locate(3,3);
        lcd.putc(68);
        wait(0.5);
        
        lcd.locate(4,3);
        lcd.putc(69);
        wait(0.5);
        lcd.locate(5,2);
        lcd.putc(70);
        wait(0.5);
        lcd.locate(6,1);
        lcd.putc(71);
        wait(0.5);
        lcd.locate(7,0);
        lcd.putc(72);
        wait(0.5);
        
        lcd.cls();
        wait(0.5);                     
    }
}
