/*************************************************************************
* Test of "format specifiers" and display those on a 20x4 Optrex LCD
* This LCD needs a different timing than a normal LCD, see the 
* OptrexLCD program for more information.
* Probally this program will work also with a "normal" 20x4 LCD
* if not replace the OptrexLCD library with the original TextLCD library.  
**************************************************************************
On www.mekong.net/tech/printf.htmt I found:
<< start
Format Specifiers for C  
Back in the day, I used to occasionally trot out my faithful old copy of Borland C++ Version 5.02, and throw 
together a kludgy little program to cope with some obscure problem. However, I never learned C well, and I don't 
use it often enough to remember even the most basic stuff... such as how to tell the "printf" function what type 
of expression I want to display. I finally got tired of looking through the help to try to find the complete list, 
so I just threw together the following list, pulled from Tony Zhang's fine book Teach Yourself C in 24 Hours. (OK, 
there is no way in hell anyone learns C in 24 hours, but still... it's a good book.) And here is the list of 
available format specifiers:
        %c     The character format specifier.
        %d     The integer format specifier.
        %i     The integer format specifier (same as %d).
        %e     The scientific notation format specifier.
        %E     The scientific notation format specifier.
        %f     The floatingpoint format specifier. 
        %g     Uses %f or %e, whichever result is shorter.
        %G     Uses %f or %E, whichever result is shorter.
        %o     The unsigned octal format specifier.
        %s     The string format specifier.
        %u     The unsigned integer format specifier.
        %x     The unsigned hexadecimal format specifier.
        %X     The unsigned hexadecimal format specifier.
        %p     Displays the corresponding argument that is a pointer.
        %n     Records the number of characters written so far.
        %%     Outputs a percent sign.

I don't understand what the hell all of these do. I also never understood the difference between %e and %E, or %x 
and %X, until a guy named Cary Wyman was kind enough to email an explanation: while %e and %x will display any
letters in lowercase, %E and %X will display them in uppercase. Cary also explains that "%d is the normal 
specifier for integers; for input, slightly different formatting rules apply when you use % (eg, you don't write 
32L to indicate that 32 is a long); for output, %i makes no difference." I still don't quite get that, but at this 
point I'd say chances are just about zero that I'll ever need to.
>> end

Also I found a list of specifiers in the book of Warwick E.Smith C programming pubished by Elektor p.220. This is almost the same list.
And in the book C++ in 21 days of Jesse Liberty Published by SAMS on p.577 (dutch edition) I found some other usefull 
information for reducing the output string length. There is also a lot usefull info at http://en.wikipedia.org/wiki/Printf.  

I'll try to use al those format specifiers in different programs and show the results on a 20x4 LCD.        
        
*/        

#include "mbed.h"
#include "OptrexLCD.h"

DigitalOut BlinkLed(LED4);

TextLCD lcd(p10, p12, p15, p16, p17, p18, TextLCD::LCD20x4 ); // rs, e, d0-d3  

void WaitRefres(int a) // procedure for showing the result for 3 seconds before getting the next datatypes 
{
    wait(a);
    lcd.cls();
    BlinkLed = !BlinkLed;
} 
    
int main() 
{
    lcd.cls();
    BlinkLed = 1;   // show the program is running
    while(1)
    {   
        int i = 0; 
        lcd.printf("     The use of\n");
        lcd.printf("   Integer Format\n");
        lcd.printf("     Specifiers\n");
        lcd.printf("     @e.sjoukes");
        WaitRefres(3);
        
        lcd.printf("The use of %%d and %%i");   // with %% its posible to print a single % character
        i = 65;
        lcd.printf("     %%d i= %d\n", i);      
        i = -38;
        lcd.printf("     %%i i= %i\n", i); 
        i = 15;
        lcd.printf("    %%+d i= %+d", i);   // The + sign causes printf to always denote the sign '+' or '-' of a number 
                                            // (the default is to omit the sign for positive numbers). Only applicable to numeric types.
        WaitRefres(5);
        
        lcd.printf("Use of fixed numbers"); 
        i = 58;
        lcd.printf("5 nums %%5d: %5d\n", i);    // Causes printf to left-pad the output with spaces until 
                                                // the required length of output is attained.
        i = 694;
        lcd.printf("5 nums %%5i: %5i\n", -i);   
        i =12345;
        int n = 5;
        lcd.printf("X nums %%*d: %*d\n", n, i); // Causes printf to pad the output until it is n characters wide. 
        WaitRefres(5);
        
        lcd.printf("With leading zero's\n");
        i =65;
        lcd.printf("6nums  %%06d: %06d\n", i);  // Causes printf to use 0 instead of spaces to left-fill a fixed-length field.
        i = 89;
        lcd.printf("6nums %%+06d: %+06d\n", i);
        i = 578;
        n = 6;
        lcd.printf("X nums %%0*i: %0*i\n", n, -i);
        
        WaitRefres(5);
   } 
}
