/*************************************************************************
* Test of "format specifiers" and display those on a 20x4 Optrex LCD
* This LCD needs a different timing than a normal LCD, see the 
* OptrexLCD program for more information.
* Probally this program will work also with a "normal" 20x4 LCD
* if not replace the OptrexLCD library with the original TextLCD library.  
**************************************************************************
*/
#include "mbed.h"
#include "OptrexLCD.h"

DigitalOut BlinkLed(LED4);

TextLCD lcd(p10, p12, p15, p16, p17, p18, TextLCD::LCD20x4 ); // rs, e, d0-d3  

void WaitRefres(int a) // procedure for showing the result for  'a' seconds before getting the next datatypes 
{
    wait(a);
    lcd.cls();
    BlinkLed = !BlinkLed;
} 
    
int main() 
{
    lcd.cls();
    BlinkLed = 1;   // show the program is running
    while(1)
    {
        lcd.printf("     The use of\n");
        lcd.printf("    Floatingpoint\n");
        lcd.printf("  Format Specifiers\n");
        lcd.printf("     @e.sjoukes");
        WaitRefres(3);
        
        float f = 0;
        lcd.printf("Default notations 1\n"); 
        lcd.printf("for f= 0 \n");
        lcd.printf("   %%f= %f\n",f);           //float notation takes 6 nummers after the point in this case 6 zero's.
        WaitRefres(5);
        
        f = 12.345678;
        lcd.printf("Default notations 2\n");
        lcd.printf("for f= 12.345678\n");
        lcd.printf("   %%f= %f\n",f);
        WaitRefres(5);
        
        f = 12345.678;
        lcd.printf("BUT \n");
        lcd.printf("for f= 12345.678\n");
        lcd.printf("   %%f= %f\n",f);           //again notation takes 6 nummers after the point but now there is a fault
        lcd.printf("the fault= 0.000266");
        WaitRefres(7.5);
        
        f =1234.12345;
        lcd.printf("for   f= 1234.12345\n");
        lcd.printf("  %%9.2f= %9.2f\n", f);        
        lcd.printf(" %%09.2f= %09.2f\n", f);
        lcd.printf("%%+09.2f= %+09.2f", f);
        WaitRefres(7.5);

        
        lcd.printf("A very big number\n");
        float f1 = 10000000000000000000;
        float f2 = 10000000000000000000;
        f1 = f1*f2;                                 //seems that it's not possible to write 100,000,000,000,000,000,000,000,000,000,000,000,000  
        lcd.printf("for f= 1e38 %%f= \n%38.0f",f1); //at once to the program.
        WaitRefres(5);
        
        lcd.printf("A too big number\n");
        lcd.printf("%%f= %f\n",f1*10);
        lcd.printf("Uppercast with %%F\n");
        lcd.printf("%%F= %F\n",f1*10); 
        WaitRefres(5);
        
        lcd.printf("A very small number\n");
        f = 0.0000000000000000000000000000000000001;
        lcd.printf("for f= 1e-38 %%f= \n%39.37f\n", f);
        WaitRefres(5);
   } 
}