/*************************************************************************
* Gets the length of mbeds datatypes and display those on a 20x4 Optrex LCD
* This LCD needs a different timing than a normal LCD, see the 
* OptrexLCD program for more information. 
**************************************************************************/

#include "mbed.h"
#include "OptrexLCD.h"

DigitalOut BlinkLed(LED4);

TextLCD lcd(p10, p12, p15, p16, p17, p18, TextLCD::LCD20x4 ); // rs, e, d0-d3

void WaitRefres() // procedure for showing the result for 3 seconds before getting the next datatypes 
{
    wait(3);
    lcd.cls();
    BlinkLed = !BlinkLed;
}    
    
int main() 
{
    BlinkLed = 1;   // show the program is running
    while(1)
    {    
        lcd.printf("sizeof(char)  == %d\n", sizeof(char));
        lcd.printf("sizeof(short) == %d\n", sizeof(short));
        lcd.printf("sizeof(int)   == %d\n", sizeof(int));
        lcd.printf("sizeof(long)  == %d\n", sizeof(long));
        WaitRefres();
        
        lcd.printf("sizeof(float)  == %d\n", sizeof(float));
        lcd.printf("sizeof(double) == %d\n", sizeof(double));
        lcd.printf("sizeof(bool)   == %d\n", sizeof(bool));
        WaitRefres();
        
        lcd.printf("sizeof(long double)\n == %d\n", sizeof(long double));
        lcd.printf("sizeof(long long)\n == %d\n", sizeof(long long));
        WaitRefres();
    } 
}
