/*
Program to run the Ascii code on a 20x4 LCD screen.
*/

#include "mbed.h"
#include "OptrexLCD.h"

DigitalOut BlinkLed(LED4);

TextLCD lcd(p10, p12, p15, p16, p17, p18, TextLCD::LCD20x4 ); // rs, e, d0-d3  
    
int main() 
{
    lcd.cls();
    BlinkLed = 1;   // show the program is running
    char i = 0;     // char is only 1 byte (0..255) if i = 255 then next step starts on 0 again.
    
    while(1)
    {    
        lcd.printf("For Dec:%03d Char= %c\n", i, i++); // %03d displays 3 fixed numbers with trailing zero's.
        wait(0.5);
        
        BlinkLed = !BlinkLed; // if led is blinking the programs runs
        
    } 
}
