/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_BUTTON_SERVICE_H__
#define __BLE_BUTTON_SERVICE_H__

class ButtonService
{
public:
    const static uint16_t BUTTON_SERVICE_UUID              = 0xA000;
    const static uint16_t BUTTON_STATE_CHARACTERISTIC_UUID = 0xA001;

    ButtonService(BLE &_ble, bool buttonPressedInitial) :
        ble(_ble), buttonState(BUTTON_STATE_CHARACTERISTIC_UUID,
                               (uint8_t []) {
        0,0
    },
    GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY) {
        GattCharacteristic *charTable[] = {&buttonState};
        GattService         buttonService(ButtonService::BUTTON_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(buttonService);
    }

    void updateButtonState(float roll, float pitch, float yaw, int16_t gx, int16_t gy, int16_t gz) {      
        uint8_t *rollValue;
        rollValue = reinterpret_cast<uint8_t*>(&roll);
        
        uint8_t *pitchValue;
        pitchValue = reinterpret_cast<uint8_t*>(&pitch);
        
        uint8_t *yawValue;
        yawValue = reinterpret_cast<uint8_t*>(&yaw);
        
        uint8_t *gxValue;
        gxValue = reinterpret_cast<uint8_t*>(&gx);
        
        uint8_t *gyValue;
        gyValue = reinterpret_cast<uint8_t*>(&gy);
        
        uint8_t *gzValue;
        gzValue = reinterpret_cast<uint8_t*>(&gz);
        
        uint8_t result[20];
        
        copy(rollValue, rollValue + 4, result);
        copy(pitchValue, pitchValue + 4, result + 4);
        copy(yawValue, yawValue + 4, result + 8);
        
        copy(gxValue, gxValue + 2, result + 12);
        copy(gyValue, gyValue + 2, result + 14);
        copy(gzValue, gzValue + 2, result + 16);
        
        //uint8_t gxLowerValue = gx & 0xff;
        //uint8_t gxHighValue = gx >> 8
        
        //uint8_t gyLowerValue = gy & 0xff;
        //uint8_t gyHighValue = gy >> 8
        
        //uint8_t gzLowerValue = gz & 0xff;
        //uint8_t gzHighValue = gz >> 8
        
        //result[13] = gxLowerValue;
        //result[14] = gxHighValue;
        
        //result[15] = gyLowerValue;
        //result[16] = gyHighValue;
        
        //result[17] = gzLowerValue;
        //result[18] = gzHighValue;
                
        ble.gattServer().write(buttonState.getValueHandle(), (uint8_t *)result, sizeof(result));
    }

private:
    BLE                              &ble;
    ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(uint8_t[20])>  buttonState;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
