#include <mbed.h>
#include <BNO080.h>
#include "Watchdog.h"
#include <BNO080Wheelchair.h>

int main()
{
    Serial pc(USBTX, USBRX, 57600);
    // Create IMU, passing in output stream, pins, I2C address, and I2C frequency
    // These pin assignments are specific to stm32- L432KC
    //BNO080 imu(&pc, D4, D5, D12, D10, 0x4b, 100000);

    //NUCLEO- F767ZI
    BNO080Wheelchair imu(&pc, D2, D4, D13, D15, 0x4b, 100000);


    Watchdog dog(&imu);
    dog.Configure(4);         //need to find the time for entire program to run
    imu.setup();
    // Tell the IMU to report rotation every 100ms and acceleration every 200ms

    // imu.enableReport(BNO080::TOTAL_ACCELERATION, 100);
    // imu.enableReport(BNO080::ROTATION, 100);

    while (true) {
        wait(.001f);

        // poll the IMU for new data -- this returns true if any packets were received
        if(imu.hasNewData(BNO080::TOTAL_ACCELERATION)) {
            // now check for the specific type of data that was received (can be multiple at once)

            pc.printf("Acc in X: %f\n", imu.accel_x());

            pc.printf("Rot in X: ");
            TVector4 eulerRadians = imu.rotation();
            TVector4 eulerDegrees = eulerRadians * (180.0 / M_PI);
            eulerDegrees.print(pc, true);
            pc.printf("\n");
            dog.Service();

        }
    }

}

