

//*****************************************************************************
//  COMANDO  MOVER MOTOR
//  |POS 1|POS 2|POS 3|POS 4| POS 5|
//  |  <  | #C  | a   | b   |  >   |
//
// #C -> indica el comando
// a,b,c,d parametros del comando
// <,> -> inicio,  y fin de comando 
//  el inicio de comando no se almacena en el buffer
//*****************************************************************************

#include "mbed.h"
#include "mbed.h"
#include "mbed.h"

#define MAXPOS 255
#define DEBUG 1
#define BUFF_SIZE 6
#define COMM_N 0
#define INITPARAMETER  1

// COMANDOS 
#define LED_NC 0
#define PUNTO 1
#define LINEA 2
#define CUADRADO 3
#define CIRCULO 4
#define HOME 5
#define RESOLUCION 6
#define TIEMPO_PASO 7
#define STOP 8
#define PAUSA 9
#define REANUDAR 10

Serial command(USBTX, USBRX);
DigitalOut led(LED1);

PwmOut servoX(PB_3);
PwmOut servoY(PB_5);
PwmOut servoZ(PB_4);


InterruptIn detener(PA_9);
InterruptIn pause(PC_7);
InterruptIn reanudar(PB_6);

float xvalue, yvalue;
int xisquare, yisquare,lenght,xlado,ylado,vel;
double down=160;
double up=240;
double i,j,r,p=0,tim=60,yip;
 
 
    int coord2pulse(float coord)
{
    if(0 <= coord <= MAXPOS)
    return int(coord*1000/150+750);
    return 750;
}
 
 
void vertex2d(float x, float y, float z)
{ 
    int pulseX = coord2pulse(x);
    int pulseY = coord2pulse(y);
    int pulseZ = coord2pulse(z);
    servoX.pulsewidth_us(pulseX);
    servoY.pulsewidth_us(pulseY);
    servoZ.pulsewidth_us(pulseZ);
}

uint8_t buffer_command[BUFF_SIZE]={0,0,0,0,0,0};

void print_num(uint8_t val)
{
if (val <10)
        command.putc(val+0x30);
    else 
        command.putc(val-9+0x40);        
}

void print_bin2hex (uint8_t val)
{
    command.printf(" 0x");
    print_num(val>>4);
    print_num(val&0x0f);              
}


// TODO : TIMEOUT UART SERIAL
void Read_command()
{
    for (uint8_t i=0; i<BUFF_SIZE;i++)
    buffer_command[i]=command.getc();   
}


void echo_command()
{
    for (uint8_t i=0; i<BUFF_SIZE;i++)
    print_bin2hex(buffer_command[i]);     
}


uint8_t check_command()
{
       if (buffer_command[BUFF_SIZE-1]== '>')
        return 1;
        return 0;        
}


void command_led(uint8_t tm)
{
  //EJEMPLO DE COMANDO 
    #if DEBUG
    command.printf("%i, segundos", tm);
    #endif
          led=1;  
          wait(tm);
          led=0;                   
}

 void maxpos()
 {
 vertex2d(255 ,255,150);
 }  
 
  void home()
{   vertex2d(245,245,up);
    wait_ms(vel);
}               

  void punto(uint8_t x, uint8_t y)
  {  
    vertex2d(x,y,up);
    wait_ms(vel);
    vertex2d(x,y,down);
    wait_ms(vel);
    vertex2d(x,y,up);
    wait_ms(vel);
  }   
  
   void tiempo_paso(uint8_t tim)
  {  
  vel = tim * 10;
  wait_ms(100);
  }   
  
  
void linea(uint8_t xi,uint8_t xf,uint8_t mi)
{    
    for(xi=xi;xi<=xf;xi++)
    {
    yip = mi*xi;
    vertex2d(xi,yip,down);
    wait_ms(30);    
    }
}

void cuadrado(uint8_t xi, uint8_t yi,uint8_t lenght)
{
 xlado = lenght + xi;
 ylado = lenght + yi;
 
 vertex2d(xi,yi,up);
 wait_ms(vel);
 vertex2d(xi,yi,down);
 wait_ms(vel);
 vertex2d(xlado,yi,down);  
 wait_ms(vel);
 vertex2d(xlado,ylado,down); 
 wait_ms(vel);
 vertex2d(xi,ylado,down); 
 wait_ms(vel);
 vertex2d(xi,yi,down); 
 wait_ms(vel);
 }
 
 void resolucion(uint8_t xi)
 {
      p=xi;    
 }
 
  
  void circulo(uint8_t x1, uint8_t y1,uint8_t r)
  {
  double  x2,y2;
  vertex2d(x1 ,y1,up);
  wait(1);
  wait_ms(vel);
 
  for (  x2=0;x2<=r;x2++){
      y2= pow(((r*r)-(x2*x2)),0.5);
      i=  x2+x1;  
      j=y1+y2;
      vertex2d(i ,j,down) ;
      wait_ms(30);
      }
       
    for (  x2=r;x2>=0;x2--){
      y2= pow(((r*r)-(x2*x2)),0.5);   
      i=  x2+x1;  
      j= y1 - y2;
      vertex2d(i ,j,down) ;
      wait_ms(30);
       }
  
  for (  x2=0;x2<=r;x2++){
      y2= pow(((r*r)-(x2*x2)),0.5);   
      i=  x1- x2;  
      j= y1 - y2;
      vertex2d(i ,j,down) ;
      wait_ms(30);
       }
  for (  x2=r;x2>=0;x2--){
      y2= pow(((r*r)-(x2*x2)),0.5);   
      i=  x1-x2;  
      j=y1+y2;
      vertex2d(i ,j,down) ;
      wait_ms(30);
       }
      vertex2d(i ,j,up) ;
      wait_ms(vel);
      
      if(x2==r)
      {
      wait(1);  
    }
    }


void command_exe()
{
    #if DEBUG
    command.printf("Ejecutando comando: ");
    #endif
    
switch (buffer_command[COMM_N])
{

case (LED_NC): 
    #if DEBUG
    command.printf("LED on\n");
    #endif
    command_led(buffer_command[INITPARAMETER]);
break;


case (PUNTO): 
    punto(buffer_command[INITPARAMETER],buffer_command[INITPARAMETER+1]);    
    #if DEBUG
    command.printf("Dibujando punto");
    #endif
break;


case (LINEA):
    linea(buffer_command[INITPARAMETER],buffer_command[INITPARAMETER+1],buffer_command[INITPARAMETER+2]); 
    #if DEBUG
    command.printf("Dibujando linea");
    #endif
break;


case  (CUADRADO):
    cuadrado(buffer_command[INITPARAMETER],buffer_command[INITPARAMETER+1],buffer_command[INITPARAMETER+2]); 
    #if DEBUG
    command.printf("Dibujando cuadrado");
    #endif
break;


case (CIRCULO):
    circulo(buffer_command[INITPARAMETER],buffer_command[INITPARAMETER+1],buffer_command[INITPARAMETER+2]); 
    #if DEBUG
    command.printf("Dibujando circulo");
    #endif
break;

case(HOME):
    home(); 
    #if DEBUG
    command.printf("Enviando a home");
    #endif
    
    break;
    
     
case (TIEMPO_PASO): 
    tiempo_paso(buffer_command[INITPARAMETER]);    
    #if DEBUG
    command.printf("cambio de tiempo realizado\vel");
    #endif
    
break;  
    
default:

    #if DEBUG
    command.printf("comando  no encontrado\n");
    #endif        
}
}


int main() 
{
    #if DEBUG
    command.printf("inicio con debug\n");
    #else
    command.printf("inicio sin debug\n");
    #endif
    uint8_t val;
    
    
    
    
    while(1)
    {
    val=command.getc();
    if (val== '<'){
    Read_command();
    if (check_command())
    {
    command_exe();        
    }
    
    else
    {
        #if DEBUG
        command.printf("\n ERROR COMANDO -> ");
        echo_command();
       #endif
    }        
    }
    
    else
    {
         #if DEBUG
         command.printf("error de inicio de trama: ");
         command.putc(val);
         #endif
    }    
    }
    }
