//********************************************************************************************
//                                                                                           *
// AB&T Tecnologie Informatiche - Ivrea Italy                                                *
// http://www.bausano.net                                                                    *
// https://www.ethercat.org/en/products/791FFAA126AD43859920EA64384AD4FD.htm                 *
//                                                                                           *  
//********************************************************************************************    
//                                                                                           *
// This software is distributed as an example, in the hope that it could be useful,          *
// WITHOUT ANY WARRANTY, even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE       *
//                                                                                           *
//******************************************************************************************** 


// revision 2 - moved  "DigitalOut Led(LED1)"



//---- AB&T EasyCAT shield loopback test 170912 ---------------------------------------------  
//
// Derived from the example Arduino project TestEasyCAT_LoopBack.ino 
// for the AB&T EasyCAT Arduino shield
//
// In this example the output bytes received by the EasyCAT are transmitted back to 
// the master, for test pourpose
//
// The EasyCAT must be set in STANDARD MODE (default setting)

//----- Tested with the STM32 NUCLEO-F767ZI board --------------------------------------------


#include "mbed.h"   
#include "EasyCAT.h"                // EasyCAT library to interface the LAN9252
    

void Application (void); 

 
 
EasyCAT EASYCAT;                    // EasyCAT instantiation


//--- sanity check to see if the EasyCAT is set in STANDARD MODE --------------------------------------

#ifdef CUST_BYTE_NUM_OUT
  #error "The EasyCAT must be set in STANDARD MODE !!!"
#endif 

#ifdef CUST_BYTE_NUM_IN
  #error "The EasyCAT must be set in STANDARD MODE !!!"
#endif 
 

//---- pins declaration ------------------------------------------------------------------------------

         


//---------------------------------------------------------------------------------------------
 
int main(void)
{
          
  printf ("\nEasyCAT - Generic EtherCAT slave\n");      // print the banner
           
                                                        //---- initialize the EasyCAT board -----
                                                                  
  if (EASYCAT.Init() == true)                           // initialization
  {                                                     // succesfully completed
    printf ("initialized\n");                           //
  }                                                            
  
  else                                                  // initialization failed   
  {                                                     // the EasyCAT board was not recognized
    printf ("initialization failed\n");                 //     
                                                        // The most common reason is that the SPI 
                                                        // chip select choosen on the board doesn't 
                                                        // match the one choosen by the firmware
                                                            
    DigitalOut Led(LED1);                               //                                                            
                                                                  
    while (1)                                           // stay in loop for ever
    {                                                   // with the led blinking
        Led = 1;                                        //    
        wait_ms(125);                                   //   
        Led = 0;                                        //
        wait_ms(125);                                   //
    }                                                   // 
  }   
   
 
  while (1)                                             //---- main loop ---------------------------
  {      
                                                        // In the main loop we must call ciclically the 
                                                        // EasyCAT task and our application
                                                        //
                                                        // This allows the bidirectional exachange of the data
                                                        // between the EtherCAT master and our application
                                                        //
                                                        // The EasyCAT cycle and the Master cycle are asynchronous
                                                             
        wait_ms(10);                                    // This delay allows us to set the EasyCAT cycle time  
                                                        // according to the needs of our application
      
        EASYCAT.MainTask();                             // execute the EasyCAT task
                                                                      
        Application();                                  // execute the user application
    }      
}


//---- user application ------------------------------------------------------------------------------

void Application ()                                    // the received bytes for the outputs                                    
                                                       // are transmitted back, simulating the inputs
{                         
  uint8_t Index;

  for (Index=0; Index < BYTE_NUM; Index++)             // BYTE_NUM is a constant declared in the library file "EasyCAT.h"
                                                       // it defines the number of bytes for the input and for the output                                           
                                                       // when the EasyCAT is configured in STANDARD MODE (default setting)
                                                                                                                                                                             
  {                                                    // the data are crossed and complemented 
    EASYCAT.BufferIn.Byte[BYTE_NUM - 1 - Index] =  EASYCAT.BufferOut.Byte[Index] ^ 0xFF; 

                                                       // the data are trasmitted back as they are  
    //EASYCAT.BufferIn.Byte[Index] =  EASYCAT.BufferOut.Byte[Index];                       
  }
}   
  
 








