//********************************************************************************************    
//                                                                                           *
// This software is distributed as an example, "AS IS", in the hope that it could            *
// be useful, WITHOUT ANY WARRANTY of any kind, express or implied, included, but            *
// not limited,  to the warranties of merchantability, fitness for a particular              *
// purpose, and non infringiment. In no event shall the authors be liable for any            *    
// claim, damages or other liability, arising from, or in connection with this software.     *
//                                                                                           *
//********************************************************************************************/



#ifndef SPI_STMPE610_H
#define SPI_STMPE610_H

#include "mbed.h"


class SPI_STMPE610 
{
    
public:

    SPI_STMPE610(PinName mosi, PinName miso, PinName sclk, PinName cs);
 
    bool GetPoint(uint16_t *X, uint16_t *Y);

  
private:

    SPI m_spi;
    DigitalOut m_cs;
    
    bool GetRawPoint(uint16_t *X, uint16_t *Y);
    uint8_t Read8(uint8_t Addr);
    uint16_t Read16(uint8_t Addr);  
    void Write8(uint8_t Addr, uint8_t Data);
    
};

#endif /* SPI_STMPE610_H */