#include "mbed.h"
#include "wifi.h"
#include "US100.h"
#include "NetworkInterface.h"
#include "ISM43362Interface.h"
#include "http_request.h"
#include "ServoMove.h"
#include <string>

/* Private defines -----------------------------------------------------------*/
#define WIFI_WRITE_TIMEOUT 10000
#define WIFI_READ_TIMEOUT  10000
#define CONNECTION_TRIAL_MAX          10

/* Private typedef------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
Serial pc(SERIAL_TX, SERIAL_RX);
ISM43362Interface wifi(MBED_CONF_APP_WIFI_SPI_MOSI, MBED_CONF_APP_WIFI_SPI_MISO, MBED_CONF_APP_WIFI_SPI_SCLK, MBED_CONF_APP_WIFI_SPI_NSS, MBED_CONF_APP_WIFI_RESET, MBED_CONF_APP_WIFI_DATAREADY, MBED_CONF_APP_WIFI_WAKEUP, false);
uint8_t  MAC_Addr[6]; 
uint8_t  IP_Addr[4];

// Interval(second) to do tasking &sensing
const int INTERVAL  = 1;
// Distance sensor
US100 sensor(PC_3, PC_4);
// Select network interface 
NetworkInterface* network = &wifi;

int main()
{

    pc.baud(9600);

    printf("\n");
    printf("************************************************************\n");
    printf("***          IoT Final Project - TSENG, I-SHENG          ***\n");
    printf("************************************************************\n");

    /*Initialize  WIFI module */
    if(WIFI_Init() ==  WIFI_STATUS_OK) {
        printf("> WIFI Module Initialized.\n");  
        if(WIFI_GetMAC_Address(MAC_Addr) == WIFI_STATUS_OK) {
            printf("> es-wifi module MAC Address : %X:%X:%X:%X:%X:%X\n",     
                   MAC_Addr[0],
                   MAC_Addr[1],
                   MAC_Addr[2],
                   MAC_Addr[3],
                   MAC_Addr[4],
                   MAC_Addr[5]);   
        } else {
            printf("> ERROR : CANNOT get MAC address\n");
        }
    
        if( WIFI_Connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, WIFI_ECN_WPA2_PSK) == WIFI_STATUS_OK) {
            printf("> es-wifi module connected \n");
            if(WIFI_GetIP_Address(IP_Addr) == WIFI_STATUS_OK) {
                printf("> es-wifi module got IP Address : %d.%d.%d.%d\n",     
                       IP_Addr[0],
                       IP_Addr[1],
                       IP_Addr[2],
                       IP_Addr[3]); 
            } else {
                printf("> ERROR : es-wifi module CANNOT get IP address\n");
            }
        } else {
            printf("> ERROR : es-wifi module NOT connected\n");
        }
    } else {
        printf("> ERROR : WIFI Module cannot be initialized.\n"); 
    }
    
    while(1){      
        char c[] = "";
        int d = sensor.distance();
        sprintf(c, "%d", d);
        printf("Distance = %d \n", d);

        char body[] = "{\"result\":";
        char body_1[] = "}";
        strcat(body,c);
        strcat(body,body_1);

        HttpRequest* POST_request = new HttpRequest(network, HTTP_POST, "http://140.115.111.187:8080/Ray/v1.0/Datastreams(1)/Observations");
        POST_request->set_header("Content-Type", "application/json");
        HttpResponse* POST_response = POST_request->send(body, strlen(body));
        printf("HTTP POST sending...\n");
        // if response is NULL, check response->get_error()

        printf("status is %d - %s\n", POST_response->get_status_code(), POST_response->get_status_message());
        printf("body is:\n%s\n", POST_response->get_body_as_string().c_str());
        
        delete POST_request; // also clears out the response
        
                
        HttpRequest* request = new HttpRequest(network, HTTP_GET, "http://140.115.111.187:8080/Ray/v1.0/Datastreams(2)/Observations?$top=1&$orderby=phenomenonTime%20desc");
        HttpResponse* response = request->send();
        // if response is NULL, check response->get_error()

//        printf("status is %d - %s\n", response->get_status_code(), response->get_status_message());
//        printf("body is:\n%s\n", response->get_body_as_string().c_str());
        
        string JSON = response->get_body_as_string();
        string LOCK = "LOCK";
        string UNLOCK = "unlock";

        if(strstr(JSON.c_str(),LOCK.c_str()) != NULL){
            printf("LOCK\n");
            servo.pulsewidth_us(700);
/*            const char lock[] = "{\"result\":\"LOCK\"}";
            HttpRequest* LOCK_request = new HttpRequest(network, HTTP_POST, "http://140.115.111.187:8080/Ray/v1.0/Datastreams(2)/Observations");
            LOCK_request->set_header("Content-Type", "application/json");
            HttpResponse* LOCK_response = LOCK_request->send(lock, strlen(lock));
            // if response is NULL, check response->get_error()

            printf("status is %d - %s\n", LOCK_response->get_status_code(), LOCK_response->get_status_message());
//            printf("body is:\n%s\n", LOCK_response->get_body_as_string().c_str());
        
            delete LOCK_request; // also clears out the response
*/
        }else if(strstr(JSON.c_str(),UNLOCK.c_str()) != NULL){
            printf("UNLOCK\n");
            servo.pulsewidth_us(2500);
/*            const char unlock[] = "{\"result\":\"unlock\"}";
            HttpRequest* UNLOCK_request = new HttpRequest(network, HTTP_POST, "http://140.115.111.187:8080/Ray/v1.0/Datastreams(2)/Observations");
            UNLOCK_request->set_header("Content-Type", "application/json");
            HttpResponse* UNLOCK_response = UNLOCK_request->send(unlock, strlen(unlock));
            // if response is NULL, check response->get_error()

            printf("status is %d - %s\n", UNLOCK_response->get_status_code(), UNLOCK_response->get_status_message());
//            printf("body is:\n%s\n", UNLOCK_response->get_body_as_string().c_str());
        
            delete UNLOCK_request; // also clears out the response
*/
        }
      
        delete request;
        
        printf("%s\n","END...");
        wait(INTERVAL);
    }
}





        


