#include "US100.h"
#include "mbed.h"
US100::US100(PinName t, PinName e) : trig(t), echo(e) {}
// Trigger Echo
// ______ _____________,,,,,,,,,
// ____| 10us |_________| 150us-25ms, or 38ms if no obstacle
//
//return echo duration in us (refer to digram above)
int US100::echo_duration()
{
    timer.reset();
    trig = 0;
    wait_us(10);
    trig = 1;
    wait_us(10);
    trig = 0;
    while(echo == 0);
    timer.start();
    while(echo == 1);
    timer.stop();
    return timer.read_us();
}

int US100::distance()
{
int duration = echo_duration();
int distacne_mm = duration*0.34/2/10;
return distacne_mm;
}