#include "mbed.h"
#include "SevenSegmentDisplay.h"

#define PLUS 1
#define DRIVE 2
#define MOTOR 3
#define STOP 4
#define MINUS 5



DigitalInOut   D(P0_11);         //Drive
DigitalInOut   M(P0_13);         //Motor
DigitalInOut   S(P0_14);         //Stop (brake)



void DisplayError(int, int);

SevenSegmentDisplay Screens(INSTANT);

int main()
{
    int Test = 0;

    D.input();
    M.input();
    S.input();

    D.mode(PullUp);
    M.mode(PullUp);
    S.mode(PullDown);


    /*************************************************************** TEST 1 - all pull ups, 0V = 0 **************************************************************/

    Test = 1;
    Screens.DisplayDigits(Test, 36); //Say we're doing test 1
    wait(0.5);

    if (D == 1) {                                                                       //Marling = 0 Amp board = 0 Marling + motor = 1
        //if (S == 1) {
            if (M == 0)                                                                 //Marling = 0 Amp board = 1 Marling + motor = 0
                {}
            else {
                DisplayError(Test, MOTOR);
            }
        //} else {
        //    DisplayError(Test, STOP);
        //}
    } else {
        DisplayError(Test, DRIVE);
    }

    /*************************************************************** TEST 2 - ALL PULL UPS, D = 0V **************************************************************/

    //Minus reverts to pull up, D is now pulled down.
    D.output();
    D = 0;

    Test = 2;

    Screens.DisplayDigits(Test, 36); 
    wait(0.5);
    
    if (M == 1) {
       // if (S == 1)
       // {}
       // else 
       // {
       //     DisplayError(Test, STOP);
       // }
    } 
    else 
    {
        DisplayError(Test, MOTOR);
    }



    /*************************************************************** TEST 3 - All pull ups, M = 0 ***************************************************************/


    Test = 3;
    Screens.DisplayDigits(Test, 36);
    wait(0.5);
    
    D.input();      //Set D back to an input so I can read it
    D.mode(PullUp); //And I'm testing things with pull ups
    
    M.output();     //Make it so I can drive M.
    M = 0;          //Drive M low


    if (D == 1) {                                                                        //Marling = 0 Amp board  = 0 Marling + motor = 1
        //if (S == 1)
        //{}
        //else 
       // {
       //     DisplayError(Test, STOP);
       // }
    } 
    else 
    {
        DisplayError(Test, DRIVE);
    }


    /*************************************************************** TEST 4 - ALL PULL UPS, S = 0 ***************************************************************/

    //Test = 4;
    
    //M.input();      //M is back to an input
    //M.mode(PullUp); 
    //S.output();     //Set S to be an output
    //S = 0;          // and drive it low.

    //Screens.DisplayDigits(Test, 36);
    //wait(0.5);

   // if (D == 0) {
   //     if (M == 1)
   //         {}
    //    else {
    //        DisplayError(Test, MOTOR);
    //    }
    //} else {
    //    DisplayError(Test, DRIVE);
   // }


    /*************************************************************** TEST 5 - ALL PULL DOWNS, 0V = 1 ************************************************************/
    Test = 5;
    Screens.DisplayDigits(Test, 36);
    wait(0.5);
    
    //S.input();  //Set S back to being an input
    //S.mode(PullDown); //We're testing pull downs now.
    
    D.mode(PullDown);
    M.mode(PullDown);

    if (D == 0) {
        if (M == 0) {                                                           //Marling = 0 amp board = 1 Marling + motor = 0
            //if (S == 0)
            //    {}
           // else {
           //     DisplayError(Test, STOP);
          //  }
        } else {
            DisplayError(Test, MOTOR);
        }
    } else {
        DisplayError(Test, DRIVE);
    }

    /*************************************************************** TEST 6 - ALL PULL DOWNS, D = 1 *************************************************************/
    Test = 6;
    Screens.DisplayDigits(Test, 36);
    wait(0.5);

    D.output();
    D = 1;      //Drive D high


    if (M == 1) {                                                               //Marling = 0 Amp board = 1
        //if (S == 0)
        //    {}
       // else {
       //     DisplayError(Test, STOP);
       // }
    } else {
        DisplayError(Test, MOTOR);
    }



    /*************************************************************** TEST 7 - ALL PULL DOWNS, M = 1 *************************************************************/

    Test = 7;
    Screens.DisplayDigits(Test, 36);
    wait(0.5);

    D.input();
    D.mode(PullDown);
    
    M.output(); //Testing M now
    M = 1;


    if (D == 0) {
        //if (S == 0)
         //   {}
        //else {
        //    DisplayError(Test, STOP);
        //}
    } else {
        DisplayError(Test, DRIVE);
    }

    /*************************************************************** TEST 8 - ALL PULL DOWNS, S = 1 *************************************************************/

    Test = 8;
    Screens.DisplayDigits(Test, 36);
    wait(0.5);

    M.input();
    M.mode(PullDown);
   // S.output();
   // S = 1;


   // if (D == 0) {
   //     if (M == 1)
   //         {}
   //     else {
   //         DisplayError(Test, MOTOR);
    //    }
    //} else {
   //     DisplayError(Test, DRIVE);
   // }
    
    //S = 0;

    /*************************************************************** TEST 9 - DRIVE THE MOTOR *******************************************************************/

    Test = 9;
    Screens.DisplayDigits(Test, 36);

    D.output();
    D = 1;
   // S.output();
    //S = 0;
    M.mode(PullNone);   //Highlight if there's a problem

    wait(0.5); //LEDs still aren't turning on.


    if (M == 0) 
    {} 
    else 
    {
        DisplayError(Test, MOTOR);
    }
    D = 0; //Making it look like there's a break between tests
    wait (0.3);



    /*************************************************************** TEST 10 - BRAKE THE MOTOR ******************************************************************/
//This seems to be giving an odd result.
 //   Test = 10;
 //   Screens.DisplayDigits(1, 0);
//wait(0.5);
//D = 0;
//S.output();
//S = 1;
 //   D = 0; //Turn the drive off
 //   S = 1;   //Turn the brake on
 //   M.mode(PullNone);   //I have to pull this down to make it perform as expected.

 //   wait(0.5); //Wait a little while to make sure the LEDs turn on, and panic if they don't.



 //   if (M == 1) 
 //   {} 
 //   else 
 //   {
  //      DisplayError(Test, MOTOR);
 //   }
  //  
  //  S = 0; //Turn off the LED for the success display.

/***************************************************************     CONGRATULATIONS     ************************************************************************/

    while(1) {
        Screens.DisplayDigits(36, 28); //_S
        wait(0.2);
        Screens.DisplayDigits(28, 31); //SU
        wait(0.2);
        Screens.DisplayDigits(31, 12); //UC
        wait(0.2);
        Screens.DisplayDigits(12, 12); //CC
        wait(0.2);
        Screens.DisplayDigits(12, 14); //CE
        wait(0.2);
        Screens.DisplayDigits(14, 28); //ES
        wait(0.2);
        Screens.DisplayDigits(28, 28); //SS
        wait(0.2);
        Screens.DisplayDigits(28, 36); //S_
        wait(0.2);
        Screens.DisplayDigits(36, 36); //__
        wait(0.5);
    }

}//End of main


/*Displays a message based on where the program thinks the error was found. Sits there blinking until the program is reset. */
void DisplayError (int WhichTest, int WhereTheProblemIs)
{
    int i = 0;
    D = 0;
    for (i = 0; i < 3; i++) {
        Screens.DisplayDigits(8,8);     //Flash all segments on and off three times to attract attention.
        wait(0.3);
        Screens.DisplayDigits(36,36);
        wait(0.3);
    }

    if (WhichTest < 10) {
        while (1) {
            switch(WhereTheProblemIs) {
                case DRIVE: {
                    Screens.DisplayDigits(WhichTest, 13);
                    wait(0.5);
                    break;
                }
                case MOTOR: {
                    Screens.DisplayDigits(WhichTest, 22);
                    wait(0.5);
                    break;
                }
            } //End switch
            Screens.DisplayDigits(36, 36);
            wait(0.5);
        } //End while loop  BUT IT WILL NEVER END MUA HA HA HA HA
    } //End of if less than 10
    else {
        while (1) {
            switch(WhereTheProblemIs) {

                case DRIVE: {
                    Screens.DisplayDigits(36, 13); //L = off, R = D
                    wait(0.5);
                    break;
                }
                case MOTOR: {
                    Screens.DisplayDigits(36, 22); //L = off, R = M
                    wait(0.5);
                    break;
                } //end case
            } //end switch
            Screens.DisplayDigits(WhichTest/10, WhichTest%10); //Display the test number over two digits
            wait(0.5);
        } //end while
    } //end else
} //End of DisplayError